<?php
/**
 * Review Comments Template
 *
 * Closing li is left out on purpose!.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/review.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>

<?php
$rating             = intval( get_comment_meta( $comment->comment_ID, 'rating', true ) );
$verified           = wc_review_is_from_verified_owner( $comment->comment_ID );
?>
<li itemprop="review" itemscope itemtype="http://schema.org/Review" <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">

	<div id="comment-<?php comment_ID(); ?>" class="comment_container">

		<?php echo get_avatar( $comment, apply_filters( 'woocommerce_review_gravatar_size', '190' ), '' ); ?>

		<div class="comment-text">


			<?php if ( '0' == $comment->comment_approved ) : ?>

				<p class="entry-meta"><em><?php esc_html_e( 'Your comment is awaiting approval', 'nailhammer' ); ?></em></p>

			<?php else : ?>

				<p class="entry-meta">
						<span itemprop="author"><?php echo esc_html__( 'Posted by', 'nailhammer' ) . ' <span>';
							comment_author();
							?></span></span> <?php

					if ( 'yes' === get_option( 'woocommerce_review_rating_verification_label' ) ) {
						if ( $verified ) {
							echo '<span class="verified">(' . esc_html__( 'verified owner', 'nailhammer' ) . ')</span> ';
						}
					}

					?> <span itemprop="datePublished"><?php esc_html_e( '- Published on', 'nailhammer' ); ?>
						<time datetime="<?php echo get_comment_date( 'c' );
						?>"><?php echo get_comment_date( wc_date_format() ); ?></time></span>
				</p>

			<?php endif; ?>

			<?php do_action( 'woocommerce_review_before_comment_meta', $comment ); ?>

			<?php do_action( 'woocommerce_review_before_comment_text', $comment ); ?>

			<div itemprop="description" class="description"><?php comment_text(); ?></div>

			<?php do_action( 'woocommerce_review_after_comment_text', $comment ); ?>

		</div>
	</div>
