<?php
/**
 * Single Product Thumbnails
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-thumbnails.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.2
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $post, $product, $woocommerce;

if ( defined( 'WC_VERSION' ) && version_compare( WC_VERSION, '3.0', '>=' ) ) {
	$attachment_ids = $product->get_gallery_image_ids();
} else {
	$attachment_ids = $product->get_gallery_attachment_ids();
}

/**
 * Add product thumbnail
 *
 * @param type $link
 * @param type $attachment_id
 * @param type $post_ID
 * @param type $image_class
 *
 * @return stroke
 */
function nailhammer_woocommerce_single_product_image_thumbnail_html( $link, $attachment_id, $post_ID, $image_class ) {
	$image_link      = wp_get_attachment_url( $attachment_id );
	$image_title     = esc_attr( get_the_title( $attachment_id ) );
	$image_caption   = esc_attr( get_post_field( 'post_excerpt', $attachment_id ) );
	$image           = wp_get_attachment_image( $attachment_id, apply_filters( 'single_product_small_thumbnail_size', 'shop_thumbnail' ), 0, $attr = array(
		'title' => $image_title,
		'alt'   => $image_title
	) );
	$large_thumb_src = wp_get_attachment_image_src( $attachment_id, apply_filters( 'single_product_large_thumbnail_size', 'shop_single' ) );

	return sprintf( '<div class="thumbnail %s" data-href="%s" data-thumb="%s" title="%s">%s</div>', $image_class, $image_link, $large_thumb_src[0], $image_caption, $image );
}

/**
 * Single product images
 *
 * @see nailhammer_woocommerce_single_product_image_thumbnail_html()
 * @see nailhammer_woocommerce_product_gallery_attachment_ids()
 *
 */
add_filter( 'woocommerce_single_product_image_thumbnail_html', 'nailhammer_woocommerce_single_product_image_thumbnail_html', 10, 4 );


if ( $attachment_ids ) {
	$loop 		= 0;
	$uniqid = uniqid();
	$GLOBALS['uniqid'] = $uniqid;

	$data_attr_array = apply_filters( 'nailhammer_product_thumbnails_data_attr_filter', array(
		'class'                     => 'nailhammer-carousel swiper-container',
		'data-slides-per-view'      => '4',
		'data-slides-per-view-xs'   => '2',
		'data-slides-per-view-sm'   => '3',
		'data-slides-per-view-md'   => '4',
		'data-slides-per-view-lg'   => '4',
		'data-slides-per-group'     => '1',
		'data-slides-per-column'    => '1',
		'data-space-between-slides' => '20',
		'data-duration-speed'       => '500',
		'data-swiper-loop'          => 'false',
		'data-free-mode'            => 'false',
		'data-grab-cursor'          => 'true',
		'data-mouse-wheel'          => 'false'
	));

	$data_attr_line = 'class="' . $data_attr_array['class'] . '"';
	$data_attr_line .= ' data-uniq-id="swiper-carousel-' . $uniqid . '"';
	$data_attr_line .= ' data-slides-per-view="' . $data_attr_array['data-slides-per-view'] . '"';
	$data_attr_line .= ' data-slides-per-view-xs="' . $data_attr_array['data-slides-per-view-xs'] . '"';
	$data_attr_line .= ' data-slides-per-view-sm="' . $data_attr_array['data-slides-per-view-sm'] . '"';
	$data_attr_line .= ' data-slides-per-view-md="' . $data_attr_array['data-slides-per-view-md'] . '"';
	$data_attr_line .= ' data-slides-per-view-lg="' . $data_attr_array['data-slides-per-view-lg'] . '"';
	$data_attr_line .= ' data-slides-per-group="' . $data_attr_array['data-slides-per-group'] . '"';
	$data_attr_line .= ' data-slides-per-column="' . $data_attr_array['data-slides-per-column'] . '"';
	$data_attr_line .= ' data-space-between-slides="' . $data_attr_array['data-space-between-slides'] . '"';
	$data_attr_line .= ' data-duration-speed="' . $data_attr_array['data-duration-speed'] . '"';
	$data_attr_line .= ' data-swiper-loop="' . $data_attr_array['data-swiper-loop'] . '"';
	$data_attr_line .= ' data-free-mode="' . $data_attr_array['data-free-mode'] . '"';
	$data_attr_line .= ' data-grab-cursor="' . $data_attr_array['data-grab-cursor'] . '"';
	$data_attr_line .= ' data-mouse-wheel="' . $data_attr_array['data-mouse-wheel'] . '"';

	echo '<div class="swiper-carousel-container">';
	echo '<div id="swiper-carousel-' . $uniqid . '" ' . $data_attr_line . '>';

	?>

	<div class="swiper-wrapper"><?php

		foreach ( $attachment_ids as $attachment_id ) {

			$classes = array( 'zoom', 'product', 'swiper-slide' );

			$image_class = implode( ' ', $classes );
			$props       = wc_get_product_attachment_props( $attachment_id, $post );

			if ( ! $props['url'] ) {
				continue;
			}

			echo apply_filters(
				'woocommerce_single_product_image_thumbnail_html',
				sprintf(
					'<a href="%s" class="%s" title="%s" data-rel="prettyPhoto[product-gallery]">%s</a>',
					esc_url( $props['url'] ),
					esc_attr( $image_class ),
					esc_attr( $props['caption'] ),
					wp_get_attachment_image( $attachment_id, apply_filters( 'single_product_small_thumbnail_size', 'shop_thumbnail' ), 0, $props )
				),
				$attachment_id,
				$post->ID,
				esc_attr( $image_class )
			);

			$loop++;
		}

		?></div>
	<?php

	global $uniqid;
	echo '</div>';
	echo '<div id="swiper-carousel-' . $uniqid . '-next" class="swiper-button-next button-next"></div><div id="swiper-carousel-' . $uniqid . '-prev" class="swiper-button-prev button-prev"></div>';
	echo '</div>';
	unset($GLOBALS['uniqid']);

}
