<?php
/**
 * Plugins configuration example.
 *
 * @var array
 */
$plugins = array(
	'cherry-data-importer' => array(
		'name'   => esc_html__( 'Cherry Data Importer', 'nailhammer' ),
		'source' => 'remote', // 'local', 'remote', 'wordpress' (default).
		'path'   => 'https://github.com/CherryFramework/cherry-data-importer/archive/master.zip',
		'access' => 'base',
	),
	'tm-mega-menu' => array(
		'name'   => esc_html__( 'TM Mega Menu', 'nailhammer' ),
		'source' => 'remote',
		'path'   => 'http://cloud.cherryframework.com/downloads/free-plugins/tm-mega-menu.zip',
		'access' => 'skins',
	),
	'tm-woocommerce-ajax-filters' => array(
		'name'   => esc_html__( 'TM WooCommerce Ajax Filters', 'nailhammer' ),
		'source' => 'local',
		'path'   => NAILHAMMER_THEME_DIR . '/assets/includes/plugins/tm-woocommerce-ajax-filters.zip',
		'access' => 'skins',
	),
	'tm-woocommerce-quick-view' => array(
		'name'   => esc_html__( 'TM WooCommerce Quick View', 'nailhammer' ),
		'source' => 'local',
		'path'   => NAILHAMMER_THEME_DIR . '/assets/includes/plugins/tm-woocommerce-quick-view.zip',
		'access' => 'skins',
	),
	'power-builder' => array(
		'name'   => esc_html__( 'Power Builder', 'nailhammer' ),
		'source' => 'local',
		'path'   => 'http://cloud.cherryframework.com/downloads/free-plugins/power-builder-upd.zip',
		'access' => 'skins',
	),
	'power-builder-integrator' => array(
		'name'   => esc_html__( 'Power Builder Integrator', 'nailhammer' ),
		'source' => 'remote',
		'path'   => 'http://cloud.cherryframework.com/downloads/free-plugins/power-builder-integrator.zip',
		'access' => 'skins',
	),
	'cherry-sidebars' => array(
		'name'   => esc_html__( 'Cherry Sidebars', 'nailhammer' ),
		'access' => 'skins',
	),
	'woocommerce' => array(
		'name'   => esc_html__( 'Woocommerce', 'nailhammer' ),
		'access' => 'skins',
	),
	'tm-woocommerce-package' => array(
		'name'   => esc_html__( 'TM Woocommerce Package', 'nailhammer' ),
		'access' => 'skins',
	),
	'tm-woocommerce-compare-wishlist' => array(
		'name'   => esc_html__( 'TM Woocommerce Compare Wishlist', 'nailhammer' ),
		'access' => 'skins',
	),
	'woocommerce-currency-switcher' => array(
		'name'   => esc_html__( 'WooCommerce Currency Switcher', 'nailhammer' ),
		'access' => 'skins',
	),
	'woocommerce-social-media-share-buttons' => array(
		'name'   => esc_html__( 'Woocommerce Social Media Share Buttons', 'nailhammer' ),
		'access' => 'skins',
	),
	'cherry-popups' => array(
		'name'   => esc_html__( 'Cherry PopUps', 'nailhammer' ),
		'access' => 'skins',
	),
	'cherry-team-members' => array(
		'name'   => esc_html__( 'Cherry Team Members', 'nailhammer' ),
		'access' => 'skins',
	),
	'cherry-testi' => array(
		'name'   => esc_html__( 'Cherry Testimonials', 'nailhammer'),
		'access' => 'skins',
	),
	'tm-timeline' => array(
		'name'   => esc_html__( 'TM Timeline', 'nailhammer' ),
		'access' => 'skins',
	),
	'motopress-slider' => array(
		'name'   => esc_html__( 'Motopress slider', 'nailhammer' ),
		'source' => 'local',
		'path'   => NAILHAMMER_THEME_DIR . '/assets/includes/plugins/motopress-slider.zip',
		'access' => 'skins',
	),
	'cherry-socialize' => array(
		'name'   => esc_html__( 'Cherry Socialize', 'nailhammer'),
		'access' => 'skins',
	),
);

/**
 * Skins configuration example
 *
 * @var array
 */
$skins = array(
	'base' => array(
		'cherry-data-importer',
	),
	'advanced' => array(
		'default' => array(
			'full'  => array(
				'tm-mega-menu',
				'tm-woocommerce-ajax-filters',
				'tm-woocommerce-quick-view',
				'power-builder',
				'power-builder-integrator',
				'cherry-sidebars',
				'woocommerce',
				'tm-woocommerce-package',
				'tm-woocommerce-compare-wishlist',
				'woocommerce-currency-switcher',
				'woocommerce-social-media-share-buttons',
				'cherry-popups',
				'cherry-team-members',
				'cherry-testi',
				'tm-timeline',
				'motopress-slider',
				'cherry-socialize',
			),
			'lite'  => false,
			'demo'  => 'http://ld-wp.template-help.com/woocommerce_64124',
			'thumb' => get_template_directory_uri() . '/assets/demo-content/default-thumb.png',
			'name'  => esc_html__( 'Nailhammer', 'nailhammer' ),
		),
	),
);

$texts = array(
	'theme-name' => 'Nailhammer',
);
