<?php
/**
 * Template part for top panel in header.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Nailhammer
 */

// Don't show top panel if all elements are disabled.
if ( ! nailhammer_is_top_panel_visible() ) {
	return;
}

$contact_block_visibility = get_theme_mod( 'header_contact_block_visibility', nailhammer_theme()->customizer->get_default( 'header_contact_block_visibility' ) );
$menu                     = has_nav_menu( 'top' );
?>

<div class="top-panel <?php echo nailhammer_get_invert_class_customize_option( 'top_panel_bg' ); ?>">
	<div class="top-panel__container container">
		<div class="top-panel__top">
			
				<div class="top-panel__left">
					<?php if ( $contact_block_visibility ) { ?>
						<?php nailhammer_contact_block( 'header' );?>
					<?php } ?>
					<?php nailhammer_currency_switcher() ?>
				</div>
			
			<div class="top-panel__right">
				
				<?php if ( $menu ) { ?>
					<div class="top-panel__menu-wrap dropdown-wrap__block">
						<i class="linearicon linearicon-cog icon-drodown"></i>
						<?php nailhammer_top_menu(); ?>
					</div>
				<?php } ?>
				<?php nailhammer_header_cart(); ?>	
			</div>
		</div>
	</div>
</div><!-- .top-panel -->
