<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Nailhammer
 */
?>
<div class="wrap-error-404">
	<section class="error-404 not-found">
		<header class="page-header">
			<h1 class="page-title screen-reader-text"><?php esc_html_e( '404', 'nailhammer' ); ?></h1>
		</header><!-- .page-header -->

		<div class="page-content">
			<h3><?php esc_html_e( 'Page Not Found.', 'nailhammer' ); ?></h3>
			<p><?php esc_html_e( 'Unfortunately the page you were looking for could not be found.', 'nailhammer' ); ?></p>

			<p><a class="btn btn-secondary" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home page', 'nailhammer' ); ?></a></p>

		</div><!-- .page-content -->
	</section><!-- .error-404 -->
</div>