<?php


if ( defined( 'WC_VERSION' ) && version_compare( WC_VERSION, '2.3', '>=' ) ) {
	add_filter( 'woocommerce_add_to_cart_fragments', 'nailhammer_cart_link_fragment' );
} else {
	add_filter( 'add_to_cart_fragments', 'nailhammer_cart_link_fragment' );
}


/**
 * Wiistroid WooCommerce Theme hooks.
 *
 * @package Wiistroid
 */

add_action( 'after_setup_theme', 'nailhammer_woocommerce_support' );

/**
 * Remove Woocommerce bootstrap grid
 *
 */
add_filter( 'tm_woocommerce_include_bootstrap_grid', 'nailhammer_woocommerce_include_bootstrap_grid' );

/**
 * Product Loop Items.
 *
 * @see nailhammer_product_image_wrap_open()
 * @see nailhammer_woowishlist_add_button_loop()
 * @see nailhammer_woocompare_add_button_loop()
 * @see nailhammer_compare_wishlist_wrap_open()
 * @see nailhammer_compare_wishlist_wrap_close()
 * @see nailhammer_compare_wishlist_wrap_list_open()
 * @see nailhammer_compare_wishlist_wrap_list_close()
 * @see nailhammer_product_content_wrap_open()
 * @see nailhammer_product_content_wrap_close()
 * @see nailhammer_woocommerce_list_categories()
 * @see nailhammer_template_loop_product_title()
 * @see nailhammer_woocommerce_template_loop_rating()
 * @see nailhammer_woocommerce_template_loop_rating_list()
 * @see nailhammer_woowishlist_add_button_loop()
 * @see nailhammer_woocommerce_template_loop_rating_list()
 * @see nailhammer_woocompare_add_button_loop_list()
 * @see nailhammer_woocommerce_display_short_excerpt()
 * @see woocommerce_template_loop_product_link_open()
 * @see woocommerce_template_loop_product_link_close()
 * @see woocommerce_template_loop_price()
 * @see nailhammer_product_content_inner_close()
 */
remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
remove_action( 'woocommerce_after_shop_loop_item', 'tm_woowishlist_add_button_loop', 12 );
remove_action( 'woocommerce_after_shop_loop_item', 'tm_woocompare_add_button_loop', 12 );
remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );

add_action( 'woocommerce_before_shop_loop_item', 'nailhammer_product_image_wrap_open', 2 ); // open
// block_product_thumbnail

add_action( 'woocommerce_before_shop_loop_item', 'nailhammer_compare_wishlist_wrap_open', 3 );
add_action( 'woocommerce_before_shop_loop_item', 'nailhammer_woowishlist_add_button_loop', 4 );
add_action( 'woocommerce_before_shop_loop_item', 'nailhammer_woocompare_add_button_loop', 5 );
add_action( 'woocommerce_before_shop_loop_item', 'nailhammer_compare_wishlist_wrap_close', 7 );

 // close wishlist_compare_button_block
add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_link_open', 8 ); //open link
add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_link_close', 10 ); //close link
add_action( 'woocommerce_before_shop_loop_item_title', 'nailhammer_product_image_wrap_close', 11 ); // close block_product_thumbnail

add_action( 'woocommerce_shop_loop_item_title', 'nailhammer_woocommerce_list_categories', 9 );
add_action( 'woocommerce_shop_loop_item_title', 'nailhammer_template_loop_product_title', 10 ); // Title
add_action( 'woocommerce_shop_loop_item_title', 'nailhammer_woocommerce_display_short_excerpt', 11 );
add_action( 'woocommerce_shop_loop_item_title', 'nailhammer_product_list_wrap_open', 6 );

add_action( 'woocommerce_shop_loop_item_title', 'nailhammer_product_description_wrap_open', 7 );
add_action( 'woocommerce_after_shop_loop_item', 'nailhammer_woocommerce_template_loop_rating', 10 ); // rating


add_action( 'woocommerce_after_shop_loop_item', 'nailhammer_woocommerce_template_loop_rating_list', 8 ); // rating for horizontal layout
add_action( 'woocommerce_after_shop_loop_item', 'nailhammer_product_description_wrap_close', 30 );

add_action( 'woocommerce_after_shop_loop_item', 'nailhammer_woowishlist_add_button_loop_list', 11 );
add_action( 'woocommerce_after_shop_loop_item', 'nailhammer_woocompare_add_button_loop_list', 11 );
add_action( 'woocommerce_after_shop_loop_item', 'nailhammer_compare_wishlist_wrap_list_open', 10 ); // open wishlist_compare_button_block for horizontal layout
add_action( 'woocommerce_after_shop_loop_item', 'nailhammer_compare_wishlist_wrap_list_close', 12 ); // close wishlist_compare_button_block for horizontal layout
add_filter( 'woocommerce_sale_flash', 'nailhammer_woocommerce_sale_flash', 20, 2 ); //Sale Flash
add_filter( 'tm_woo_quick_view_button_hook', 'nailhammer_tm_woo_quick_view_button_hook' );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
add_action( 'woocommerce_before_shop_loop_item', 'woocommerce_show_product_loop_sale_flash', 11 );

add_action( 'woocommerce_after_shop_loop_item', 'nailhammer_product_list_wrap_close', 35 );

add_action( 'woocommerce_shop_loop_item_title', 'nailhammer_product_price_wrap_open', 31 );
add_action( 'woocommerce_after_shop_loop_item', 'nailhammer_woocommerce_template_loop_price_grid', 32 );
add_action( 'woocommerce_after_shop_loop_item', 'nailhammer_woocommerce_template_loop_price_list', 32 );
add_action( 'woocommerce_after_shop_loop_item', 'nailhammer_product_price_wrap_close', 33 );

add_action( 'woocommerce_before_shop_loop_item', 'nailhammer_product_content_wrap_open', 1 );
add_action( 'woocommerce_after_shop_loop_item', 'nailhammer_product_content_wrap_close', 30 );

add_action( 'woocommerce_before_subcategory', 'nailhammer_woocommerce_before_subcategory', 9 );
add_action( 'woocommerce_after_subcategory', 'nailhammer_woocommerce_after_subcategory', 11 );


/**
 * Category Loop Items.
 *
 * @see nailhammer_woocommerce_template_loop_category_title()
 * @see nailhammer_woocommerce_subcategory_thumbnail()
 * @see nailhammer_get_product_thumbnail_size()
 */
remove_action( 'woocommerce_shop_loop_subcategory_title', 'woocommerce_template_loop_category_title', 10 );
remove_action( 'woocommerce_shop_loop_subcategory_title', 'tm_wc_ajax_filters_shop_loop_subcategory_title', 10 );
remove_action( 'woocommerce_before_subcategory_title', 'woocommerce_subcategory_thumbnail', 10 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );

add_action( 'woocommerce_after_subcategory', 'nailhammer_woocommerce_template_loop_category_title', 10 );
add_action( 'woocommerce_before_subcategory_title', 'nailhammer_woocommerce_subcategory_thumbnail', 10, 2 );
add_action( 'woocommerce_before_shop_loop_item_title', 'nailhammer_get_product_thumbnail_size', 9 );

/**
 * Single Products Loop Items.
 *
 * @see nailhammer_compare_wishlist_wrap_open()
 * @see nailhammer_compare_wishlist_wrap_close()
 * @see woocommerce_template_single_rating()
 * @see toastie_wc_smsb_form_code()
 * @see nailhammer_woocommerce_output_related_up_sells_products_args()
 * @see template_loop_sold_by()
 */
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );

if ( function_exists( 'toastie_wc_smsb_form_code' ) ) {
	remove_action('woocommerce_single_product_summary', 'toastie_wc_smsb_form_code', 31);
	add_action( 'woocommerce_single_product_summary', 'toastie_wc_smsb_form_code', 45);
}

add_action( 'woocommerce_single_product_summary', 'nailhammer_compare_wishlist_wrap_open', 34 );
add_action( 'woocommerce_single_product_summary', 'nailhammer_compare_wishlist_wrap_close', 36 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 12 );

if ( class_exists( 'WCV_Vendor_Shop' ) && WC_Vendors::$pv_options->get_option( 'sold_by' ) ) {
	remove_action( 'woocommerce_after_shop_loop_item', array('WCV_Vendor_Shop', 'template_loop_sold_by'), 9 );
	add_action( 'woocommerce_before_shop_loop_item', 'nailhammer_template_loop_sold_by', 15 );
}


/**
 * Swiper arrows position
 *
 * @see nailhammer_tm_categories_carousel_widget_arrows_pos()
 */
add_filter( 'tm_categories_carousel_widget_arrows_pos', 'nailhammer_tm_categories_carousel_widget_arrows_pos' );
add_filter( 'tm_products_carousel_widget_arrows_pos', 'nailhammer_tm_categories_carousel_widget_arrows_pos' );

/**
 * Single product wrap elements
 *
 * @see nailhammer_single_product_open_wrapper()
 * @see nailhammer_single_product_close_wrapper()
 * @see nailhammer_before_single_product_image_wrap_before()
 * @see nailhammer_before_single_product_image_wrap_after()
 * @see nailhammer_before_single_product_summary_wrap_before()
 * @see nailhammer_before_single_product_summary_wrap_after()
 */
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 8 );


/**
 * Single product images
 *
 */
remove_action( 'tm_smart_box_woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );

add_action( 'tm_smart_box_woocommerce_before_shop_loop_item_title', 'nailhammer_woocommerce_template_loop_product_thumbnail_custom_size', 10 );

if ( defined( 'WC_VERSION' ) && version_compare( WC_VERSION, '3.0', '>=' ) ) {
	add_filter( 'woocommerce_product_get_gallery_image_ids', 'nailhammer_woocommerce_product_gallery_attachment_ids' );
} else {
	add_filter( 'woocommerce_product_gallery_attachment_ids', 'nailhammer_woocommerce_product_gallery_attachment_ids' );
}
add_filter( 'tm_products_smart_box_widget__cat_img_size', 'nailhammer_products_smart_box_widget__cat_img_size' );


/**
 * Change sale and date format
 *
 */
remove_action( 'woocommerce_after_shop_loop_item_title', 'tm_products_carousel_widget_sale_end_date', 11 );
if ( function_exists( 'tm_products_carousel_widget_sale_end_date' ) ) {
	add_action( 'woocommerce_before_shop_loop_item_title', 'tm_products_carousel_widget_sale_end_date', 10 );
};

/**
 * Add new and featured badge
 * @see nailhammer_woocommerce_show_flash
 */
add_action( 'woocommerce_before_shop_loop_item', 'nailhammer_woocommerce_show_flash', 12 );
add_action( 'woocommerce_before_single_product_summary', 'nailhammer_woocommerce_show_flash', 30 );


/**
 * Change layout of price
 * @see nailhammer_woocommerce_get_price_html_from_to
 */
add_filter( 'woocommerce_get_price_html_from_to', 'nailhammer_woocommerce_get_price_html_from_to', 10, 3 );

/**
 * Wrap swiper carousel
 *
 */
add_filter( 'tm_products_carousel_widget_wrapper_open', 'nailhammer_tm_products_carousel_widget_wrapper_open' );
add_filter( 'tm_products_carousel_widget_wrapper_close', 'nailhammer_tm_products_carousel_widget_wrapper_close' );

/**
 *
 * Remove woocommerce breadcrumb & deffault woo-sidebar
 */
remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );

add_filter( 'cherry_breadcrumbs_custom_trail', 'nailhammer_get_woo_breadcrumbs', 10, 2 );

remove_filter( 'post_class', 'wc_product_post_class', 20 );
add_filter( 'post_class', 'nailhammer_woo_loop_columns', 20, 3 );

remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );
add_action( 'woocommerce_after_cart', 'woocommerce_cross_sell_display', 12 );


/**
 *
 * Changed cart and checkout woo-page
 */
add_action( 'woocommerce_before_checkout_form', 'nailhammer_before_login_form_wrap', 9 );
add_action( 'woocommerce_before_checkout_form', 'nailhammer_after_login_form_wrap', 11 );

remove_action( 'woocommerce_before_checkout_form', 'woocommerce_checkout_coupon_form', 10 );
add_action( 'woocommerce_before_checkout_form', 'woocommerce_checkout_coupon_form', 15 );

add_action( 'woocommerce_before_checkout_form', 'nailhammer_before_checkout_coupon_form', 14 );
add_action( 'woocommerce_before_checkout_form', 'nailhammer_after_checkout_coupon_form', 16 );

/**
 * Register scripts for single product gallery
 *
 */
add_action( 'wp_enqueue_scripts', 'nailhammer_enqueue_assets', 11 );

/**
 * Update format sale end date to TM Woocommerce Package widget
 *
 */
add_action( 'woocommerce_before_shop_loop_item_title', 'nailhammer_products_sale_end_date', 10 );


/**
 * Add layout synchronization for product loop and product carousel widget
 *
 */
add_filter( 'tm_products_carousel_widget_hooks', 'nailhammer_products_carousel_widget_hooks'  );


/**
 * Add synchronization ajax-filter-widget in footer
 *
 */
add_filter( 'tm_wc_ajax_sidebar_before', 'nailhammer_ajax_sidebar_before', 10, 2 );
add_filter( 'tm_wc_ajax_sidebar_after', 'nailhammer_ajax_sidebar_after', 10, 2 );

/**
 * Remove woo-pagination and added theme pagination
 *
 */

add_filter( 'woocommerce_pagination_args', 'nailhammer_woocommerce_pagination_args', 10 );

add_filter( 'tm_banners_grid_widget_grids', 'nailhammer_banners_grid_widget_grids' );

/**
 * Single Product Sale Flash
 *
 */

remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
add_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 30 );
add_action( 'woocommerce_before_single_product_summary', 'nailhammer_before_single_product_summary_wrap_before', 18 );
add_action( 'woocommerce_single_product_summary', 'nailhammer_before_single_product_category', 1 );

add_action( 'woocommerce_before_single_product_summary', 'nailhammer_before_single_product_summary_wrap_after', 98 );
add_action( 'woocommerce_after_single_product_summary', 'nailhammer_after_single_product_summary_wrap', 1 );

/**
 * Change quickview button position
 */

add_filter( 'tm_compare_count_format', 'nailhammer_compare_count_format');
add_filter( 'tm_woo_quick_view_button_hook', 'nailhammer_tm_woo_quick_view_button_hook' );

/**
 * Register scripts for single product gallery
 */
add_action( 'wp_enqueue_scripts', 'nailhammer_enqueue_assets', 11 );

add_filter( 'tm_wc_ahax_filters_loader', 'nailhammer_wc_compare_wishlist_ahax_filters_loader' );
add_filter( 'tm_wc_compare_wishlist_loader', 'nailhammer_wc_compare_wishlist_ahax_filters_loader' );

add_filter( 'tm_wc_qw_product_title', 'nailhammer_wc_qw_product_title');

/**
 * Add custom wcvendors pro css classes
 */
if (class_exists( 'WCV_Vendors' )) {
	add_filter( 'body_class', 'nailhammer_body_class_wc_vendors' );
}

add_filter( 'tm_woocommerce_carousel_data_atts', 'nailhammer_carousel_columns', 10, 3 );

add_filter( 'tm_wc_products_carousel_widget_visible', 'nailhammer_wc_products_carousel_widget_visible' );

remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );

//add button to product list
add_action( 'woocommerce_before_shop_loop_item', 'nailhammer_template_loop_add_to_cart_grid', 2 );
add_action( 'woocommerce_after_shop_loop_item', 'nailhammer_template_loop_add_to_cart_list', 2 );