<?php
/**
 * Theme Customizer.
 *
 * @package Nailhammer
 */

/**
 * Retrieve a holder for Customizer options.
 *
 * @since  1.0.0
 * @return array
 */
function nailhammer_get_customizer_options() {
	/**
	 * Filter a holder for Customizer options (for theme/plugin developer customization).
	 *
	 * @since 1.0.0
	 */
	return apply_filters( 'nailhammer_get_customizer_options' , array(
		'prefix'     => 'nailhammer',
		'capability' => 'edit_theme_options',
		'type'       => 'theme_mod',
		'options'    => array(

			/** `Site Indentity` section */
			'show_tagline' => array(
				'title'    => esc_html__( 'Show tagline after logo', 'nailhammer' ),
				'section'  => 'title_tagline',
				'priority' => 60,
				'default'  => false,
				'field'    => 'checkbox',
				'type'     => 'control',
			),
			'totop_visibility' => array(
				'title'    => esc_html__( 'Show ToTop button', 'nailhammer' ),
				'section'  => 'title_tagline',
				'priority' => 61,
				'default'  => true,
				'field'    => 'checkbox',
				'type'     => 'control',
			),
			'page_preloader' => array(
				'title'    => esc_html__( 'Show page preloader', 'nailhammer' ),
				'section'  => 'title_tagline',
				'priority' => 62,
				'default'  => true,
				'field'    => 'checkbox',
				'type'     => 'control',
			),
			'preloader_img' => array(
				'title'           => esc_html__( 'Preloader Upload', 'nailhammer' ),
				'description'     => esc_html__( 'Upload Preloader image', 'nailhammer' ),
				'section'         => 'title_tagline',
				'default'         => false,
				'field'           => 'image',
				'type'            => 'control',
			),
			'general_settings' => array(
				'title'    => esc_html__( 'General Site settings', 'nailhammer' ),
				'priority' => 40,
				'type'     => 'panel',
			),

			/** `Logo & Favicon` section */
			'logo_favicon' => array(
				'title'    => esc_html__( 'Logo &amp; Favicon', 'nailhammer' ),
				'priority' => 25,
				'panel'    => 'general_settings',
				'type'     => 'section',
			),
			'header_logo_type' => array(
				'title'   => esc_html__( 'Logo Type', 'nailhammer' ),
				'section' => 'logo_favicon',
				'default' => 'image',
				'field'   => 'radio',
				'choices' => array(
					'image' => esc_html__( 'Image', 'nailhammer' ),
					'text'  => esc_html__( 'Text', 'nailhammer' ),
				),
				'type' => 'control',
			),
			'header_logo_url' => array(
				'title'           => esc_html__( 'Logo Upload', 'nailhammer' ),
				'description'     => esc_html__( 'Upload logo image', 'nailhammer' ),
				'section'         => 'logo_favicon',
				'default'         => '%s/assets/images/logo.png',
				'field'           => 'image',
				'type'            => 'control',
				'active_callback' => 'nailhammer_is_header_logo_image',
			),
			'invert_header_logo_url' => array(
				'title'           => esc_html__( 'Invert Logo Upload', 'nailhammer' ),
				'description'     => esc_html__( 'Upload logo image', 'nailhammer' ),
				'section'         => 'logo_favicon',
				'default'         => '%s/assets/images/invert-logo.png',
				'field'           => 'image',
				'type'            => 'control',
				'active_callback' => 'nailhammer_is_header_logo_image',
			),
			'retina_header_logo_url' => array(
				'title'           => esc_html__( 'Retina Logo Upload', 'nailhammer' ),
				'description'     => esc_html__( 'Upload logo for retina-ready devices', 'nailhammer' ),
				'section'         => 'logo_favicon',
				'field'           => 'image',
				'type'            => 'control',
				'active_callback' => 'nailhammer_is_header_logo_image',
			),
			'invert_retina_header_logo_url' => array(
				'title'           => esc_html__( 'Invert Retina Logo Upload', 'nailhammer' ),
				'description'     => esc_html__( 'Upload logo for retina-ready devices', 'nailhammer' ),
				'section'         => 'logo_favicon',
				'default'         => false,
				'field'           => 'image',
				'type'            => 'control',
				'active_callback' => 'nailhammer_is_header_logo_image',
			),
			'header_logo_font_family' => array(
				'title'           => esc_html__( 'Font Family', 'nailhammer' ),
				'section'         => 'logo_favicon',
				'default'         => 'Libre Franklin, sans-serif',
				'field'           => 'fonts',
				'type'            => 'control',
				'active_callback' => 'nailhammer_is_header_logo_text',
			),
			'header_logo_font_style' => array(
				'title'           => esc_html__( 'Font Style', 'nailhammer' ),
				'section'         => 'logo_favicon',
				'default'         => 'normal',
				'field'           => 'select',
				'choices'         => nailhammer_get_font_styles(),
				'type'            => 'control',
				'active_callback' => 'nailhammer_is_header_logo_text',
			),
			'header_logo_font_weight' => array(
				'title'           => esc_html__( 'Font Weight', 'nailhammer' ),
				'section'         => 'logo_favicon',
				'default'         => '600',
				'field'           => 'select',
				'choices'         => nailhammer_get_font_weight(),
				'type'            => 'control',
				'active_callback' => 'nailhammer_is_header_logo_text',
			),
			'header_logo_font_size' => array(
				'title'           => esc_html__( 'Font Size, px', 'nailhammer' ),
				'section'         => 'logo_favicon',
				'default'         => '23',
				'field'           => 'number',
				'input_attrs'     => array(
					'min'  => 6,
					'max'  => 50,
					'step' => 1,
				),
				'type'            => 'control',
				'active_callback' => 'nailhammer_is_header_logo_text',
			),
			'header_logo_character_set' => array(
				'title'           => esc_html__( 'Character Set', 'nailhammer' ),
				'section'         => 'logo_favicon',
				'default'         => 'latin',
				'field'           => 'select',
				'choices'         => nailhammer_get_character_sets(),
				'type'            => 'control',
				'active_callback' => 'nailhammer_is_header_logo_text',
			),

			/** `Breadcrumbs` section */
			'breadcrumbs' => array(
				'title'    => esc_html__( 'Breadcrumbs', 'nailhammer' ),
				'priority' => 30,
				'type'     => 'section',
				'panel'    => 'general_settings',
			),
			'breadcrumbs_visibillity' => array(
				'title'   => esc_html__( 'Enable Breadcrumbs', 'nailhammer' ),
				'section' => 'breadcrumbs',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'breadcrumbs_front_visibillity' => array(
				'title'   => esc_html__( 'Enable Breadcrumbs on front page', 'nailhammer' ),
				'section' => 'breadcrumbs',
				'default' => false,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'breadcrumbs_page_title' => array(
				'title'   => esc_html__( 'Enable page title in breadcrumbs area', 'nailhammer' ),
				'section' => 'breadcrumbs',
				'default' => false,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'breadcrumbs_path_type' => array(
				'title'   => esc_html__( 'Show full/minified path', 'nailhammer' ),
				'section' => 'breadcrumbs',
				'default' => 'full',
				'field'   => 'select',
				'choices' => array(
					'full'     => esc_html__( 'Full', 'nailhammer' ),
					'minified' => esc_html__( 'Minified', 'nailhammer' ),
				),
				'type'    => 'control',
			),

			/** `Social links` section */
			'social_links' => array(
				'title'    => esc_html__( 'Social links', 'nailhammer' ),
				'priority' => 50,
				'type'     => 'section',
				'panel'    => 'general_settings',
			),
			'header_social_links' => array(
				'title'   => esc_html__( 'Show social links in header', 'nailhammer' ),
				'section' => 'social_links',
				'default' => false,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'footer_social_links' => array(
				'title'   => esc_html__( 'Show social links in footer', 'nailhammer' ),
				'section' => 'social_links',
				'default' => false,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'blog_post_share_buttons' => array(
				'title'   => esc_html__( 'Show social sharing to blog posts', 'nailhammer' ),
				'section' => 'social_links',
				'default' => false,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'single_post_share_buttons' => array(
				'title'   => esc_html__( 'Show social sharing to single blog post', 'nailhammer' ),
				'section' => 'social_links',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),

			/** `Page Layout` section */
			'page_layout' => array(
				'title'    => esc_html__( 'Page Layout', 'nailhammer' ),
				'priority' => 55,
				'type'     => 'section',
				'panel'    => 'general_settings',
			),
			'header_container_type' => array(
				'title'   => esc_html__( 'Header type', 'nailhammer' ),
				'section' => 'page_layout',
				'default' => 'fullwidth',
				'field'   => 'select',
				'choices' => array(
					'boxed'     => esc_html__( 'Boxed', 'nailhammer' ),
					'fullwidth' => esc_html__( 'Fullwidth', 'nailhammer' ),
				),
				'type' => 'control',
			),
			'content_container_type' => array(
				'title'   => esc_html__( 'Content type', 'nailhammer' ),
				'section' => 'page_layout',
				'default' => 'Boxed',
				'field'   => 'select',
				'choices' => array(
					'boxed'     => esc_html__( 'Boxed', 'nailhammer' ),
					'fullwidth' => esc_html__( 'Fullwidth', 'nailhammer' ),
				),
				'type' => 'control',
			),
			'footer_container_type' => array(
				'title'   => esc_html__( 'Footer type', 'nailhammer' ),
				'section' => 'page_layout',
				'default' => 'fullwidth',
				'field'   => 'select',
				'choices' => array(
					'boxed'     => esc_html__( 'Boxed', 'nailhammer' ),
					'fullwidth' => esc_html__( 'Fullwidth', 'nailhammer' ),
				),
				'type' => 'control',
			),
			'container_width' => array(
				'title'       => esc_html__( 'Container width (px)', 'nailhammer' ),
				'section'     => 'page_layout',
				'default'     => 1200,
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => 960,
					'max'  => 1920,
					'step' => 1,
				),
				'type' => 'control',
			),
			'sidebar_width' => array(
				'title'   => esc_html__( 'Sidebar width', 'nailhammer' ),
				'section' => 'page_layout',
				'default' => '1/4',
				'field'   => 'select',
				'choices' => array(
					'1/6' => '1/6',
					'1/4' => '1/4',
				),
				'sanitize_callback' => 'sanitize_text_field',
				'type'              => 'control',
			),
			'main_box_color' => array(
				'title'   => esc_html__( 'Main box color', 'nailhammer' ),
				'section' => 'page_layout',
				'default' => '#ffffff',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			/** `Color Scheme` panel */
			'color_scheme' => array(
				'title'       => esc_html__( 'Color Scheme', 'nailhammer' ),
				'description' => esc_html__( 'Configure Color Scheme', 'nailhammer' ),
				'priority'    => 40,
				'type'        => 'panel',
			),

			/** `Regular scheme` section */
			'regular_scheme' => array(
				'title'       => esc_html__( 'Regular scheme', 'nailhammer' ),
				'priority'    => 1,
				'panel'       => 'color_scheme',
				'type'        => 'section',
			),
			'regular_accent_color_1' => array(
				'title'   => esc_html__( 'Accent color (1)', 'nailhammer' ),
				'section' => 'regular_scheme',
				'default' => '#ed4c21',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'regular_accent_color_2' => array(
				'title'   => esc_html__( 'Accent color (2)', 'nailhammer' ),
				'section' => 'regular_scheme',
				'default' => '#676767',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'regular_accent_color_3' => array(
				'title'   => esc_html__( 'Accent color (3)', 'nailhammer' ),
				'section' => 'regular_scheme',
				'default' => '#999',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'regular_accent_color_4' => array(
				'title'   => esc_html__( 'Accent color (4)', 'nailhammer' ),
				'section' => 'regular_scheme',
				'default' => '#59bc6c',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'regular_text_color' => array(
				'title'   => esc_html__( 'Text color', 'nailhammer' ),
				'section' => 'regular_scheme',
				'default' => '#909090',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'regular_link_color' => array(
				'title'   => esc_html__( 'Link color', 'nailhammer' ),
				'section' => 'regular_scheme',
				'default' => '#ec2f2f',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'regular_link_hover_color' => array(
				'title'   => esc_html__( 'Link hover color', 'nailhammer' ),
				'section' => 'regular_scheme',
				'default' => '#222222',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'regular_h1_color' => array(
				'title'   => esc_html__( 'H1 color', 'nailhammer' ),
				'section' => 'regular_scheme',
				'default' => '#0d1117',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'regular_h2_color' => array(
				'title'   => esc_html__( 'H2 color', 'nailhammer' ),
				'section' => 'regular_scheme',
				'default' => '#0d1117',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'regular_h3_color' => array(
				'title'   => esc_html__( 'H3 color', 'nailhammer' ),
				'section' => 'regular_scheme',
				'default' => '#0d1117',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'regular_h4_color' => array(
				'title'   => esc_html__( 'H4 color', 'nailhammer' ),
				'section' => 'regular_scheme',
				'default' => '#0d1117',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'regular_h5_color' => array(
				'title'   => esc_html__( 'H5 color', 'nailhammer' ),
				'section' => 'regular_scheme',
				'default' => '#0d1117',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'regular_h6_color' => array(
				'title'   => esc_html__( 'H6 color', 'nailhammer' ),
				'section' => 'regular_scheme',
				'default' => '#0d1117',
				'field'   => 'hex_color',
				'type'    => 'control',
			),

			/** `Invert scheme` section */
			'invert_scheme' => array(
				'title'       => esc_html__( 'Invert scheme', 'nailhammer' ),
				'priority'    => 1,
				'panel'       => 'color_scheme',
				'type'        => 'section',
			),
			'invert_accent_color_1' => array(
				'title'   => esc_html__( 'Accent color (1)', 'nailhammer' ),
				'section' => 'invert_scheme',
				'default' => '#ffffff',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'invert_accent_color_2' => array(
				'title'   => esc_html__( 'Accent color (2)', 'nailhammer' ),
				'section' => 'invert_scheme',
				'default' => '#ffffff',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'invert_accent_color_3' => array(
				'title'   => esc_html__( 'Accent color (3)', 'nailhammer' ),
				'section' => 'invert_scheme',
				'default' => '#ff6161',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'invert_text_color' => array(
				'title'   => esc_html__( 'Text color', 'nailhammer' ),
				'section' => 'invert_scheme',
				'default' => '#ffffff',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'invert_link_color' => array(
				'title'   => esc_html__( 'Link color', 'nailhammer' ),
				'section' => 'invert_scheme',
				'default' => '#ffffff',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'invert_link_hover_color' => array(
				'title'   => esc_html__( 'Link hover color', 'nailhammer' ),
				'section' => 'invert_scheme',
				'default' => '#f5cdc5',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'invert_h1_color' => array(
				'title'   => esc_html__( 'H1 color', 'nailhammer' ),
				'section' => 'invert_scheme',
				'default' => '#ffffff',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'invert_h2_color' => array(
				'title'   => esc_html__( 'H2 color', 'nailhammer' ),
				'section' => 'invert_scheme',
				'default' => '#ffffff',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'invert_h3_color' => array(
				'title'   => esc_html__( 'H3 color', 'nailhammer' ),
				'section' => 'invert_scheme',
				'default' => '#ffffff',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'invert_h4_color' => array(
				'title'   => esc_html__( 'H4 color', 'nailhammer' ),
				'section' => 'invert_scheme',
				'default' => '#ffffff',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'invert_h5_color' => array(
				'title'   => esc_html__( 'H5 color', 'nailhammer' ),
				'section' => 'invert_scheme',
				'default' => '#ffffff',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'invert_h6_color' => array(
				'title'   => esc_html__( 'H6 color', 'nailhammer' ),
				'section' => 'invert_scheme',
				'default' => '#ffffff',
				'field'   => 'hex_color',
				'type'    => 'control',
			),

			/** `Typography Settings` panel */
			'typography' => array(
				'title'       => esc_html__( 'Typography', 'nailhammer' ),
				'description' => esc_html__( 'Configure typography settings', 'nailhammer' ),
				'priority'    => 45,
				'type'        => 'panel',
			),

			/** `Body text` section */
			'body_typography' => array(
				'title'       => esc_html__( 'Body text', 'nailhammer' ),
				'priority'    => 5,
				'panel'       => 'typography',
				'type'        => 'section',
			),
			'body_font_family' => array(
				'title'   => esc_html__( 'Font Family', 'nailhammer' ),
				'section' => 'body_typography',
				'default' => 'Montserrat, sans-serif',
				'field'   => 'fonts',
				'type'    => 'control',
			),
			'body_font_style' => array(
				'title'   => esc_html__( 'Font Style', 'nailhammer' ),
				'section' => 'body_typography',
				'default' => 'normal',
				'field'   => 'select',
				'choices' => nailhammer_get_font_styles(),
				'type'    => 'control',
			),
			'body_font_weight' => array(
				'title'   => esc_html__( 'Font Weight', 'nailhammer' ),
				'section' => 'body_typography',
				'default' => '300',
				'field'   => 'select',
				'choices' => nailhammer_get_font_weight(),
				'type'    => 'control',
			),
			'body_font_size' => array(
				'title'       => esc_html__( 'Font Size, px', 'nailhammer' ),
				'section'     => 'body_typography',
				'default'     => '16',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => 6,
					'max'  => 50,
					'step' => 1,
				),
				'type' => 'control',
			),
			'body_line_height' => array(
				'title'       => esc_html__( 'Line Height', 'nailhammer' ),
				'description' => esc_html__( 'Relative to the font-size of the element', 'nailhammer' ),
				'section'     => 'body_typography',
				'default'     => '1.75',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => 1.0,
					'max'  => 3.0,
					'step' => 0.1,
				),
				'type' => 'control',
			),
			'body_letter_spacing' => array(
				'title'       => esc_html__( 'Letter Spacing, em', 'nailhammer' ),
				'section'     => 'body_typography',
				'default'     => '0',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => -1,
					'max'  => 1,
					'step' => 0.01,
				),
				'type' => 'control',
			),
			'body_character_set' => array(
				'title'   => esc_html__( 'Character Set', 'nailhammer' ),
				'section' => 'body_typography',
				'default' => 'latin',
				'field'   => 'select',
				'choices' => nailhammer_get_character_sets(),
				'type'    => 'control',
			),
			'body_text_align' => array(
				'title'   => esc_html__( 'Text Align', 'nailhammer' ),
				'section' => 'body_typography',
				'default' => 'left',
				'field'   => 'select',
				'choices' => nailhammer_get_text_aligns(),
				'type'    => 'control',
			),

			/** `H1 Heading` section */
			'h1_typography' => array(
				'title'    => esc_html__( 'H1 Heading', 'nailhammer' ),
				'priority' => 10,
				'panel'    => 'typography',
				'type'     => 'section',
			),
			'h1_font_family' => array(
				'title'   => esc_html__( 'Font Family', 'nailhammer' ),
				'section' => 'h1_typography',
				'default' => 'Montserrat, sans-serif',
				'field'   => 'fonts',
				'type'    => 'control',
			),
			'h1_font_style' => array(
				'title'   => esc_html__( 'Font Style', 'nailhammer' ),
				'section' => 'h1_typography',
				'default' => 'normal',
				'field'   => 'select',
				'choices' => nailhammer_get_font_styles(),
				'type'    => 'control',
			),
			'h1_font_weight' => array(
				'title'   => esc_html__( 'Font Weight', 'nailhammer' ),
				'section' => 'h1_typography',
				'default' => '700',
				'field'   => 'select',
				'choices' => nailhammer_get_font_weight(),
				'type'    => 'control',
			),
			'h1_font_size' => array(
				'title'       => esc_html__( 'Font Size, px', 'nailhammer' ),
				'section'     => 'h1_typography',
				'default'     => '72',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => 10,
					'max'  => 200,
					'step' => 1,
				),
				'type' => 'control',
			),
			'h1_line_height' => array(
				'title'       => esc_html__( 'Line Height', 'nailhammer' ),
				'description' => esc_html__( 'Relative to the font-size of the element', 'nailhammer' ),
				'section'     => 'h1_typography',
				'default'     => '1.3',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => 0.9,
					'max'  => 3.0,
					'step' => 0.1,
				),
				'type' => 'control',
			),
			'h1_letter_spacing' => array(
				'title'       => esc_html__( 'Letter Spacing, em', 'nailhammer' ),
				'section'     => 'h1_typography',
				'default'     => '0',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => -1,
					'max'  => 1,
					'step' => 0.01,
				),
				'type' => 'control',
			),
			'h1_character_set' => array(
				'title'   => esc_html__( 'Character Set', 'nailhammer' ),
				'section' => 'h1_typography',
				'default' => 'latin',
				'field'   => 'select',
				'choices' => nailhammer_get_character_sets(),
				'type'    => 'control',
			),
			'h1_text_align' => array(
				'title'   => esc_html__( 'Text Align', 'nailhammer' ),
				'section' => 'h1_typography',
				'default' => 'inherit',
				'field'   => 'select',
				'choices' => nailhammer_get_text_aligns(),
				'type'    => 'control',
			),

			/** `H2 Heading` section */
			'h2_typography' => array(
				'title'    => esc_html__( 'H2 Heading', 'nailhammer' ),
				'priority' => 15,
				'panel'    => 'typography',
				'type'     => 'section',
			),
			'h2_font_family' => array(
				'title'   => esc_html__( 'Font Family', 'nailhammer' ),
				'section' => 'h2_typography',
				'default' => 'Montserrat, sans-serif',
				'field'   => 'fonts',
				'type'    => 'control',
			),
			'h2_font_style' => array(
				'title'   => esc_html__( 'Font Style', 'nailhammer' ),
				'section' => 'h2_typography',
				'default' => 'normal',
				'field'   => 'select',
				'choices' => nailhammer_get_font_styles(),
				'type'    => 'control',
			),
			'h2_font_weight' => array(
				'title'   => esc_html__( 'Font Weight', 'nailhammer' ),
				'section' => 'h2_typography',
				'default' => '400',
				'field'   => 'select',
				'choices' => nailhammer_get_font_weight(),
				'type'    => 'control',
			),
			'h2_font_size' => array(
				'title'       => esc_html__( 'Font Size, px', 'nailhammer' ),
				'section'     => 'h2_typography',
				'default'     => '54',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => 10,
					'max'  => 200,
					'step' => 1,
				),
				'type' => 'control',
			),
			'h2_line_height' => array(
				'title'       => esc_html__( 'Line Height', 'nailhammer' ),
				'description' => esc_html__( 'Relative to the font-size of the element', 'nailhammer' ),
				'section'     => 'h2_typography',
				'default'     => '1.1527',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => 1.0,
					'max'  => 3.0,
					'step' => 0.1,
				),
				'type' => 'control',
			),
			'h2_letter_spacing' => array(
				'title'       => esc_html__( 'Letter Spacing, em', 'nailhammer' ),
				'section'     => 'h2_typography',
				'default'     => '0',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => -1,
					'max'  => 1,
					'step' => 0.01,
				),
				'type' => 'control',
			),
			'h2_character_set' => array(
				'title'   => esc_html__( 'Character Set', 'nailhammer' ),
				'section' => 'h2_typography',
				'default' => 'latin',
				'field'   => 'select',
				'choices' => nailhammer_get_character_sets(),
				'type'    => 'control',
			),
			'h2_text_align' => array(
				'title'   => esc_html__( 'Text Align', 'nailhammer' ),
				'section' => 'h2_typography',
				'default' => 'inherit',
				'field'   => 'select',
				'choices' => nailhammer_get_text_aligns(),
				'type'    => 'control',
			),

			/** `H3 Heading` section */
			'h3_typography' => array(
				'title'    => esc_html__( 'H3 Heading', 'nailhammer' ),
				'priority' => 20,
				'panel'    => 'typography',
				'type'     => 'section',
			),
			'h3_font_family' => array(
				'title'   => esc_html__( 'Font Family', 'nailhammer' ),
				'section' => 'h3_typography',
				'default' => 'Montserrat, sans-serif',
				'field'   => 'fonts',
				'type'    => 'control',
			),
			'h3_font_style' => array(
				'title'   => esc_html__( 'Font Style', 'nailhammer' ),
				'section' => 'h3_typography',
				'default' => 'normal',
				'field'   => 'select',
				'choices' => nailhammer_get_font_styles(),
				'type'    => 'control',
			),
			'h3_font_weight' => array(
				'title'   => esc_html__( 'Font Weight', 'nailhammer' ),
				'section' => 'h3_typography',
				'default' => '700',
				'field'   => 'select',
				'choices' => nailhammer_get_font_weight(),
				'type'    => 'control',
			),
			'h3_font_size' => array(
				'title'       => esc_html__( 'Font Size, px', 'nailhammer' ),
				'section'     => 'h3_typography',
				'default'     => '30',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => 10,
					'max'  => 200,
					'step' => 1,
				),
				'type' => 'control',
			),
			'h3_line_height' => array(
				'title'       => esc_html__( 'Line Height', 'nailhammer' ),
				'description' => esc_html__( 'Relative to the font-size of the element', 'nailhammer' ),
				'section'     => 'h3_typography',
				'default'     => '1.5',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => 1.0,
					'max'  => 3.0,
					'step' => 0.1,
				),
				'type' => 'control',
			),
			'h3_letter_spacing' => array(
				'title'       => esc_html__( 'Letter Spacing, em', 'nailhammer' ),
				'section'     => 'h3_typography',
				'default'     => '0',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => -1,
					'max'  => 1,
					'step' => 0.01,
				),
				'type' => 'control',
			),
			'h3_character_set' => array(
				'title'   => esc_html__( 'Character Set', 'nailhammer' ),
				'section' => 'h3_typography',
				'default' => 'latin',
				'field'   => 'select',
				'choices' => nailhammer_get_character_sets(),
				'type'    => 'control',
			),
			'h3_text_align' => array(
				'title'   => esc_html__( 'Text Align', 'nailhammer' ),
				'section' => 'h3_typography',
				'default' => 'inherit',
				'field'   => 'select',
				'choices' => nailhammer_get_text_aligns(),
				'type'    => 'control',
			),

			/** `H4 Heading` section */
			'h4_typography' => array(
				'title'    => esc_html__( 'H4 Heading', 'nailhammer' ),
				'priority' => 25,
				'panel'    => 'typography',
				'type'     => 'section',
			),
			'h4_font_family' => array(
				'title'   => esc_html__( 'Font Family', 'nailhammer' ),
				'section' => 'h4_typography',
				'default' => 'Montserrat, sans-serif',
				'field'   => 'fonts',
				'type'    => 'control',
			),
			'h4_font_style' => array(
				'title'   => esc_html__( 'Font Style', 'nailhammer' ),
				'section' => 'h4_typography',
				'default' => 'normal',
				'field'   => 'select',
				'choices' => nailhammer_get_font_styles(),
				'type'    => 'control',
			),
			'h4_font_weight' => array(
				'title'   => esc_html__( 'Font Weight', 'nailhammer' ),
				'section' => 'h4_typography',
				'default' => '600',
				'field'   => 'select',
				'choices' => nailhammer_get_font_weight(),
				'type'    => 'control',
			),
			'h4_font_size' => array(
				'title'       => esc_html__( 'Font Size, px', 'nailhammer' ),
				'section'     => 'h4_typography',
				'default'     => '24',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => 10,
					'max'  => 200,
					'step' => 1,
				),
				'type' => 'control',
			),
			'h4_line_height' => array(
				'title'       => esc_html__( 'Line Height', 'nailhammer' ),
				'description' => esc_html__( 'Relative to the font-size of the element', 'nailhammer' ),
				'section'     => 'h4_typography',
				'default'     => '1.36',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => 1.0,
					'max'  => 3.0,
					'step' => 0.1,
				),
				'type' => 'control',
			),
			'h4_letter_spacing' => array(
				'title'       => esc_html__( 'Letter Spacing, em', 'nailhammer' ),
				'section'     => 'h4_typography',
				'default'     => '0',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => -1,
					'max'  => 1,
					'step' => 0.01,
				),
				'type' => 'control',
			),
			'h4_character_set' => array(
				'title'   => esc_html__( 'Character Set', 'nailhammer' ),
				'section' => 'h4_typography',
				'default' => 'latin',
				'field'   => 'select',
				'choices' => nailhammer_get_character_sets(),
				'type'    => 'control',
			),
			'h4_text_align' => array(
				'title'   => esc_html__( 'Text Align', 'nailhammer' ),
				'section' => 'h4_typography',
				'default' => 'inherit',
				'field'   => 'select',
				'choices' => nailhammer_get_text_aligns(),
				'type'    => 'control',
			),

			/** `H5 Heading` section */
			'h5_typography' => array(
				'title'    => esc_html__( 'H5 Heading', 'nailhammer' ),
				'priority' => 30,
				'panel'    => 'typography',
				'type'     => 'section',
			),
			'h5_font_family' => array(
				'title'   => esc_html__( 'Font Family', 'nailhammer' ),
				'section' => 'h5_typography',
				'default' => 'Montserrat, sans-serif',
				'field'   => 'fonts',
				'type'    => 'control',
			),
			'h5_font_style' => array(
				'title'   => esc_html__( 'Font Style', 'nailhammer' ),
				'section' => 'h5_typography',
				'default' => 'normal',
				'field'   => 'select',
				'choices' => nailhammer_get_font_styles(),
				'type'    => 'control',
			),
			'h5_font_weight' => array(
				'title'   => esc_html__( 'Font Weight', 'nailhammer' ),
				'section' => 'h5_typography',
				'default' => '600',
				'field'   => 'select',
				'choices' => nailhammer_get_font_weight(),
				'type'    => 'control',
			),
			'h5_font_size' => array(
				'title'       => esc_html__( 'Font Size, px', 'nailhammer' ),
				'section'     => 'h5_typography',
				'default'     => '18',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => 10,
					'max'  => 200,
					'step' => 1,
				),
				'type' => 'control',
			),
			'h5_line_height' => array(
				'title'       => esc_html__( 'Line Height', 'nailhammer' ),
				'description' => esc_html__( 'Relative to the font-size of the element', 'nailhammer' ),
				'section'     => 'h5_typography',
				'default'     => '1.66',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => 1.0,
					'max'  => 3.0,
					'step' => 0.1,
				),
				'type' => 'control',
			),
			'h5_letter_spacing' => array(
				'title'       => esc_html__( 'Letter Spacing, em', 'nailhammer' ),
				'section'     => 'h5_typography',
				'default'     => '0',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => -1,
					'max'  => 1,
					'step' => 0.01,
				),
				'type' => 'control',
			),
			'h5_character_set' => array(
				'title'   => esc_html__( 'Character Set', 'nailhammer' ),
				'section' => 'h5_typography',
				'default' => 'latin',
				'field'   => 'select',
				'choices' => nailhammer_get_character_sets(),
				'type'    => 'control',
			),
			'h5_text_align' => array(
				'title'   => esc_html__( 'Text Align', 'nailhammer' ),
				'section' => 'h5_typography',
				'default' => 'inherit',
				'field'   => 'select',
				'choices' => nailhammer_get_text_aligns(),
				'type'    => 'control',
			),

			/** `H6 Heading` section */
			'h6_typography' => array(
				'title'    => esc_html__( 'H6 Heading', 'nailhammer' ),
				'priority' => 35,
				'panel'    => 'typography',
				'type'     => 'section',
			),
			'h6_font_family' => array(
				'title'   => esc_html__( 'Font Family', 'nailhammer' ),
				'section' => 'h6_typography',
				'default' => 'Montserrat, sans-serif',
				'field'   => 'fonts',
				'type'    => 'control',
			),
			'h6_font_style' => array(
				'title'   => esc_html__( 'Font Style', 'nailhammer' ),
				'section' => 'h6_typography',
				'default' => 'normal',
				'field'   => 'select',
				'choices' => nailhammer_get_font_styles(),
				'type'    => 'control',
			),
			'h6_font_weight' => array(
				'title'   => esc_html__( 'Font Weight', 'nailhammer' ),
				'section' => 'h6_typography',
				'default' => '500',
				'field'   => 'select',
				'choices' => nailhammer_get_font_weight(),
				'type'    => 'control',
			),
			'h6_font_size' => array(
				'title'       => esc_html__( 'Font Size, px', 'nailhammer' ),
				'section'     => 'h6_typography',
				'default'     => '16',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => 10,
					'max'  => 200,
					'step' => 1,
				),
				'type' => 'control',
			),
			'h6_line_height' => array(
				'title'       => esc_html__( 'Line Height', 'nailhammer' ),
				'description' => esc_html__( 'Relative to the font-size of the element', 'nailhammer' ),
				'section'     => 'h6_typography',
				'default'     => '1.75',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => 1.0,
					'max'  => 3.0,
					'step' => 0.1,
				),
				'type' => 'control',
			),
			'h6_letter_spacing' => array(
				'title'       => esc_html__( 'Letter Spacing, em', 'nailhammer' ),
				'section'     => 'h6_typography',
				'default'     => '0',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => -1,
					'max'  => 1,
					'step' => 0.01,
				),
				'type' => 'control',
			),
			'h6_character_set' => array(
				'title'   => esc_html__( 'Character Set', 'nailhammer' ),
				'section' => 'h6_typography',
				'default' => 'latin',
				'field'   => 'select',
				'choices' => nailhammer_get_character_sets(),
				'type'    => 'control',
			),
			'h6_text_align' => array(
				'title'   => esc_html__( 'Text Align', 'nailhammer' ),
				'section' => 'h6_typography',
				'default' => 'inherit',
				'field'   => 'select',
				'choices' => nailhammer_get_text_aligns(),
				'type'    => 'control',
			),

			/** `Breadcrumbs` section */
			'breadcrumbs_typography' => array(
				'title'    => esc_html__( 'Breadcrumbs', 'nailhammer' ),
				'priority' => 45,
				'panel'    => 'typography',
				'type'     => 'section',
			),
			'breadcrumbs_font_family' => array(
				'title'   => esc_html__( 'Font Family', 'nailhammer' ),
				'section' => 'breadcrumbs_typography',
				'default' => 'Poppins, sans-serif',
				'field'   => 'fonts',
				'type'    => 'control',
			),
			'breadcrumbs_font_style' => array(
				'title'   => esc_html__( 'Font Style', 'nailhammer' ),
				'section' => 'breadcrumbs_typography',
				'default' => 'normal',
				'field'   => 'select',
				'choices' => nailhammer_get_font_styles(),
				'type'    => 'control',
			),
			'breadcrumbs_font_weight' => array(
				'title'   => esc_html__( 'Font Weight', 'nailhammer' ),
				'section' => 'breadcrumbs_typography',
				'default' => '400',
				'field'   => 'select',
				'choices' => nailhammer_get_font_weight(),
				'type'    => 'control',
			),
			'breadcrumbs_font_size' => array(
				'title'       => esc_html__( 'Font Size, px', 'nailhammer' ),
				'section'     => 'breadcrumbs_typography',
				'default'     => '12',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => 6,
					'max'  => 50,
					'step' => 1,
				),
				'type' => 'control',
			),
			'breadcrumbs_line_height' => array(
				'title'       => esc_html__( 'Line Height', 'nailhammer' ),
				'description' => esc_html__( 'Relative to the font-size of the element', 'nailhammer' ),
				'section'     => 'breadcrumbs_typography',
				'default'     => '1.5',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => 1.0,
					'max'  => 3.0,
					'step' => 0.1,
				),
				'type' => 'control',
			),
			'breadcrumbs_letter_spacing' => array(
				'title'       => esc_html__( 'Letter Spacing, em', 'nailhammer' ),
				'section'     => 'breadcrumbs_typography',
				'default'     => '0',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => -1,
					'max'  => 1,
					'step' => 0.01,
				),
				'type' => 'control',
			),
			'breadcrumbs_character_set' => array(
				'title'   => esc_html__( 'Character Set', 'nailhammer' ),
				'section' => 'breadcrumbs_typography',
				'default' => 'latin',
				'field'   => 'select',
				'choices' => nailhammer_get_character_sets(),
				'type'    => 'control',
			),

			/** `Meta` section */
			'meta_typography' => array(
				'title'       => esc_html__( 'Entry meta', 'nailhammer' ),
				'priority'    => 50,
				'panel'       => 'typography',
				'type'        => 'section',
			),
			'meta_font_family' => array(
				'title'   => esc_html__( 'Font Family', 'nailhammer' ),
				'section' => 'meta_typography',
				'default' => 'PT Serif, serif',
				'field'   => 'fonts',
				'type'    => 'control',
			),
			'meta_font_style' => array(
				'title'   => esc_html__( 'Font Style', 'nailhammer' ),
				'section' => 'meta_typography',
				'default' => 'normal',
				'field'   => 'select',
				'choices' => nailhammer_get_font_styles(),
				'type'    => 'control',
			),
			'meta_font_weight' => array(
				'title'   => esc_html__( 'Font Weight', 'nailhammer' ),
				'section' => 'meta_typography',
				'default' => '400',
				'field'   => 'select',
				'choices' => nailhammer_get_font_weight(),
				'type'    => 'control',
			),
			'meta_font_size' => array(
				'title'       => esc_html__( 'Font Size, px', 'nailhammer' ),
				'section'     => 'meta_typography',
				'default'     => '18',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => 10,
					'max'  => 200,
					'step' => 1,
				),
				'type' => 'control',
			),
			'meta_line_height' => array(
				'title'       => esc_html__( 'Line Height', 'nailhammer' ),
				'description' => esc_html__( 'Relative to the font-size of the element', 'nailhammer' ),
				'section'     => 'meta_typography',
				'default'     => '1.42',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => 1.0,
					'max'  => 3.0,
					'step' => 0.1,
				),
				'type' => 'control',
			),
			'meta_letter_spacing' => array(
				'title'       => esc_html__( 'Letter Spacing, em', 'nailhammer' ),
				'section'     => 'meta_typography',
				'default'     => '0.08',
				'field'       => 'number',
				'input_attrs' => array(
					'min'  => -1,
					'max'  => 1,
					'step' => 0.01,
				),
				'type' => 'control',
			),
			'meta_character_set' => array(
				'title'   => esc_html__( 'Character Set', 'nailhammer' ),
				'section' => 'meta_typography',
				'default' => 'latin',
				'field'   => 'select',
				'choices' => nailhammer_get_character_sets(),
				'type'    => 'control',
			),

			/** `Header` panel */
			'header_options' => array(
				'title'    => esc_html__( 'Header', 'nailhammer' ),
				'priority' => 60,
				'type'     => 'panel',
			),

			/** `Header styles` section */
			'header_styles' => array(
				'title'    => esc_html__( 'Styles', 'nailhammer' ),
				'priority' => 5,
				'panel'    => 'header_options',
				'type'     => 'section',
			),
			'header_layout_type' => array(
				'title'   => esc_html__( 'Layout', 'nailhammer' ),
				'section' => 'header_styles',
				'default' => 'style-3',
				'field'   => 'select',
				'choices' => nailhammer_get_header_layout_options(),
				'type'    => 'control',
			),
			'header_transparent_layout' => array(
				'title'   => esc_html__( 'Header overlay', 'nailhammer' ),
				'section' => 'header_styles',
				'default' => false,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'header_invert_color_scheme' => array(
				'title'   => esc_html__( 'Enable invert color scheme', 'nailhammer' ),
				'section' => 'header_styles',
				'default' => false,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'header_bg_color' => array(
				'title'   => esc_html__( 'Background Color', 'nailhammer' ),
				'section' => 'header_styles',
				'field'   => 'hex_color',
				'default' => '#ffffff',
				'type'    => 'control',
			),
			'header_bg_image' => array(
				'title'   => esc_html__( 'Background Image', 'nailhammer' ),
				'section' => 'header_styles',
				'default' => false,
				'field'   => 'image',
				'type'    => 'control',
			),
			'header_bg_repeat' => array(
				'title'   => esc_html__( 'Background Repeat', 'nailhammer' ),
				'section' => 'header_styles',
				'default' => 'no-repeat',
				'field'   => 'select',
				'choices' => array(
					'no-repeat' => esc_html__( 'No Repeat', 'nailhammer' ),
					'repeat'    => esc_html__( 'Tile', 'nailhammer' ),
					'repeat-x'  => esc_html__( 'Tile Horizontally', 'nailhammer' ),
					'repeat-y'  => esc_html__( 'Tile Vertically', 'nailhammer' ),
				),
				'type'    => 'control',
			),
			'header_bg_position_x' => array(
				'title'   => esc_html__( 'Background Position', 'nailhammer' ),
				'section' => 'header_styles',
				'default' => 'center',
				'field'   => 'select',
				'choices' => array(
					'left'   => esc_html__( 'Left', 'nailhammer' ),
					'center' => esc_html__( 'Center', 'nailhammer' ),
					'right'  => esc_html__( 'Right', 'nailhammer' ),
				),
				'type'    => 'control',
			),
			'header_bg_attachment' => array(
				'title'   => esc_html__( 'Background Attachment', 'nailhammer' ),
				'section' => 'header_styles',
				'default' => 'scroll',
				'field'   => 'select',
				'choices' => array(
					'scroll' => esc_html__( 'Scroll', 'nailhammer' ),
					'fixed'  => esc_html__( 'Fixed', 'nailhammer' ),
				),
				'type'    => 'control',
			),
			'header_search' => array(
				'title'   => esc_html__( 'Enable search', 'nailhammer' ),
				'section' => 'header_styles',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),

			/** `Top Panel` section */
			'header_top_panel' => array(
				'title'    => esc_html__( 'Top Panel', 'nailhammer' ),
				'priority' => 10,
				'panel'    => 'header_options',
				'type'     => 'section',
			),
			'top_panel_visibility' => array(
				'title'   => esc_html__( 'Enable top panel', 'nailhammer' ),
				'section' => 'header_top_panel',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'top_panel_bg' => array(
				'title'   => esc_html__( 'Background color', 'nailhammer' ),
				'section' => 'header_top_panel',
				'default' => '#131313',
				'field'   => 'hex_color',
				'type'    => 'control',
			),

			/** `Header contact block` section */
			'header_contact_block' => array(
				'title'    => esc_html__( 'Header Contact Block', 'nailhammer' ),
				'priority' => 15,
				'panel'    => 'header_options',
				'type'     => 'section',
			),
			'header_contact_block_visibility' => array(
				'title'   => esc_html__( 'Show Header Contact Block', 'nailhammer' ),
				'section' => 'header_contact_block',
				'default' => false,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'header_contact_icon_1' => array(
				'title'       => esc_html__( 'Contact item 1', 'nailhammer' ),
				'description' => esc_html__( 'Choose icon', 'nailhammer' ),
				'section'     => 'header_contact_block',
				'field'       => 'iconpicker',
				'default'     => 'fa-phone',
				'icon_data'   => array(
					'icon_set'    => 'nailhammerFontAwesome',
					'icon_css'    => NAILHAMMER_THEME_URI . '/assets/css/font-awesome.min.css',
					'icon_base'   => 'fa',
					'icon_prefix' => 'fa-',
					'icons'       => nailhammer_get_icons_set(),
				),
				'type'        => 'control',
			),
			'header_contact_label_1' => array(
				'title'       => '',
				'description' => esc_html__( 'Label', 'nailhammer' ),
				'section'     => 'header_contact_block',
				'default'     => false,
				'field'       => 'text',
				'type'        => 'control',
			),
			'header_contact_text_1' => array(
				'title'       => '',
				'description' => esc_html__( 'Description', 'nailhammer' ),
				'section'     => 'header_contact_block',
				'default'     => false,
				'field'       => 'textarea',
				'type'        => 'control',
			),
			'header_contact_icon_2' => array(
				'title'       => esc_html__( 'Contact item 2', 'nailhammer' ),
				'description' => esc_html__( 'Choose icon', 'nailhammer' ),
				'section'     => 'header_contact_block',
				'field'       => 'iconpicker',
				'default'     => false,
				'icon_data'   => array(
					'icon_set'    => 'nailhammerFontAwesome',
					'icon_css'    => NAILHAMMER_THEME_URI . '/assets/css/font-awesome.min.css',
					'icon_base'   => 'fa',
					'icon_prefix' => 'fa-',
					'icons'       => nailhammer_get_icons_set(),
				),
				'type'        => 'control',
			),
			'header_contact_label_2' => array(
				'title'       => '',
				'description' => esc_html__( 'Label', 'nailhammer' ),
				'section'     => 'header_contact_block',
				'default'     => false,
				'field'       => 'text',
				'type'        => 'control',
			),
			'header_contact_text_2' => array(
				'title'       => '',
				'description' => esc_html__( 'Description', 'nailhammer' ),
				'section'     => 'header_contact_block',
				'default'     => false,
				'field'       => 'textarea',
				'type'        => 'control',
			),
			'header_contact_icon_3' => array(
				'title'       => esc_html__( 'Contact item 3', 'nailhammer' ),
				'description' => esc_html__( 'Choose icon', 'nailhammer' ),
				'section'     => 'header_contact_block',
				'field'       => 'iconpicker',
				'default'     => false,
				'icon_data'   => array(
					'icon_set'    => 'nailhammerFontAwesome',
					'icon_css'    => NAILHAMMER_THEME_URI . '/assets/css/font-awesome.min.css',
					'icon_base'   => 'fa',
					'icon_prefix' => 'fa-',
					'icons'       => nailhammer_get_icons_set(),
				),
				'type'        => 'control',
			),
			'header_contact_label_3' => array(
				'title'       => '',
				'description' => esc_html__( 'Label', 'nailhammer' ),
				'section'     => 'header_contact_block',
				'default'     => false,
				'field'       => 'text',
				'type'        => 'control',
			),
			'header_contact_text_3' => array(
				'title'       => '',
				'description' => esc_html__( 'Description', 'nailhammer' ),
				'section'     => 'header_contact_block',
				'default'     => false,
				'field'       => 'textarea',
				'type'        => 'control',
			),

			/** `Main Menu` section */
			'header_main_menu' => array(
				'title'    => esc_html__( 'Main Menu', 'nailhammer' ),
				'priority' => 20,
				'panel'    => 'header_options',
				'type'     => 'section',
			),
			'header_menu_sticky' => array(
				'title'   => esc_html__( 'Enable sticky menu', 'nailhammer' ),
				'section' => 'header_main_menu',
				'default' => false,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'header_menu_attributes' => array(
				'title'   => esc_html__( 'Enable description', 'nailhammer' ),
				'section' => 'header_main_menu',
				'default' => false,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'more_button_type' => array(
				'title'   => esc_html__( 'More Menu Button Type', 'nailhammer' ),
				'section' => 'header_main_menu',
				'default' => 'text',
				'field'   => 'radio',
				'choices' => array(
					'image' => esc_html__( 'Image', 'nailhammer' ),
					'icon'  => esc_html__( 'Icon', 'nailhammer' ),
					'text'  => esc_html__( 'Text', 'nailhammer' ),
				),
				'type'    => 'control',
			),
			'more_button_text' => array(
				'title'           => esc_html__( 'More Menu Button Text', 'nailhammer' ),
				'section'         => 'header_main_menu',
				'default'         => esc_html__( 'More', 'nailhammer' ),
				'field'           => 'input',
				'type'            => 'control',
				'active_callback' => 'nailhammer_is_more_button_type_text',
			),
			'more_button_icon' => array(
				'title'           => esc_html__( 'More Menu Button Icon', 'nailhammer' ),
				'section'         => 'header_main_menu',
				'field'           => 'iconpicker',
				'type'            => 'control',
				'active_callback' => 'nailhammer_is_more_button_type_icon',
				'icon_data'       => array(
					'icon_set'    => 'moreButtonFontAwesome',
					'icon_css'    => NAILHAMMER_THEME_URI . '/assets/css/font-awesome.min.css',
					'icon_base'   => 'fa',
					'icon_prefix' => 'fa-',
					'icons'       => nailhammer_get_icons_set(),
				),
			),
			'more_button_image_url' => array(
				'title'           => esc_html__( 'More Button Image Upload', 'nailhammer' ),
				'description'     => esc_html__( 'Upload More Button image', 'nailhammer' ),
				'section'         => 'header_main_menu',
				'default'         => false,
				'field'           => 'image',
				'type'            => 'control',
				'active_callback' => 'nailhammer_is_more_button_type_image',
			),
			'retina_more_button_image_url' => array(
				'title'           => esc_html__( 'Retina More Button Image Upload', 'nailhammer' ),
				'description'     => esc_html__( 'Upload More Button image for retina-ready devices', 'nailhammer' ),
				'section'         => 'header_main_menu',
				'field'           => 'image',
				'type'            => 'control',
				'active_callback' => 'nailhammer_is_more_button_type_image',
			),

			/** `Sidebar` section */
			'sidebar_settings' => array(
				'title'    => esc_html__( 'Sidebar', 'nailhammer' ),
				'priority' => 105,
				'type'     => 'section',
			),
			'sidebar_position' => array(
				'title'   => esc_html__( 'Sidebar Position', 'nailhammer' ),
				'section' => 'sidebar_settings',
				'default' => 'one-left-sidebar',
				'field'   => 'select',
				'choices' => array(
					'one-left-sidebar'  => esc_html__( 'Sidebar on left side', 'nailhammer' ),
					'one-right-sidebar' => esc_html__( 'Sidebar on right side', 'nailhammer' ),
					'fullwidth'         => esc_html__( 'No sidebars', 'nailhammer' ),
				),
				'type' => 'control',
			),

			/** `MailChimp` section */
			'mailchimp' => array(
				'title'       => esc_html__( 'MailChimp', 'nailhammer' ),
				'description' => esc_html__( 'Setup MailChimp settings for subscribe widget', 'nailhammer' ),
				'priority'    => 109,
				'type'        => 'section',
			),
			'mailchimp_api_key' => array(
				'title'   => esc_html__( 'MailChimp API key', 'nailhammer' ),
				'section' => 'mailchimp',
				'field'   => 'text',
				'type'    => 'control',
			),
			'mailchimp_list_id' => array(
				'title'   => esc_html__( 'MailChimp list ID', 'nailhammer' ),
				'section' => 'mailchimp',
				'field'   => 'text',
				'type'    => 'control',
			),
			
			/** `Ads Management` panel */
			'ads_management' => array(
				'title'    => esc_html__( 'Ads Management', 'nailhammer' ),
				'priority' => 110,
				'type'     => 'section',
			),
			'ads_header' => array(
				'title'             => esc_html__( 'Header', 'nailhammer' ),
				'section'           => 'ads_management',
				'field'             => 'textarea',
				'default'           => '',
				'sanitize_callback' => 'esc_html',
				'type'              => 'control',
			),
			'ads_home_before_loop' => array(
				'title'             => esc_html__( 'Front Page Before Loop', 'nailhammer' ),
				'section'           => 'ads_management',
				'field'             => 'textarea',
				'default'           => '',
				'sanitize_callback' => 'esc_html',
				'type'              => 'control',
			),
			'ads_post_before_content' => array(
				'title'             => esc_html__( 'Post Before Content', 'nailhammer' ),
				'section'           => 'ads_management',
				'field'             => 'textarea',
				'default'           => '',
				'sanitize_callback' => 'esc_html',
				'type'              => 'control',
			),
			'ads_post_before_comments' => array(
				'title'             => esc_html__( 'Post Before Comments', 'nailhammer' ),
				'section'           => 'ads_management',
				'field'             => 'textarea',
				'default'           => '',
				'sanitize_callback' => 'esc_html',
				'type'              => 'control',
			),

			/** `Footer` panel */
			'footer_options' => array(
				'title'    => esc_html__( 'Footer', 'nailhammer' ),
				'priority' => 110,
				'type'     => 'panel',
			),

			/** `Footer styles` section */
			'footer_styles' => array(
				'title'    => esc_html__( 'Footer Styles', 'nailhammer' ),
				'priority' => 5,
				'panel'    => 'footer_options',
				'type'     => 'section',
			),
			'footer_logo_url' => array(
				'title'   => esc_html__( 'Logo upload', 'nailhammer' ),
				'section' => 'footer_styles',
				'field'   => 'image',
				'default' => '%s/assets/images/footer-logo.png',
				'type'    => 'control',
			),
			'footer_copyright' => array(
				'title'   => esc_html__( 'Copyright text', 'nailhammer' ),
				'section' => 'footer_styles',
				'default' => nailhammer_get_default_footer_copyright(),
				'field'   => 'textarea',
				'type'    => 'control',
			),
			'footer_layout_type' => array(
				'title'   => esc_html__( 'Layout', 'nailhammer' ),
				'section' => 'footer_styles',
				'default' => 'default',
				'field'   => 'select',
				'choices' => array(
					'default'  => esc_html__( 'Style 1', 'nailhammer' ),
					'centered' => esc_html__( 'Style 2', 'nailhammer' ),
					'minimal' => esc_html__( 'Style 3', 'nailhammer' ),
				),
				'type' => 'control',
			),
			'footer_widget_columns' => array(
				'title'   => esc_html__( 'Top Widget Area Columns', 'nailhammer' ),
				'section' => 'footer_styles',
				'default' => '4',
				'field'   => 'select',
				'choices' => array(
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
				),
				'type' => 'control',
			),
			'second_footer_widget_columns' => array(
				'title'   => esc_html__( 'Bottom Widget Area Columns', 'nailhammer' ),
				'section' => 'footer_styles',
				'default' => '4',
				'field'   => 'select',
				'choices' => array(
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
				),
				'type' => 'control',
			),
			'footer_bg' => array(
				'title'   => esc_html__( 'Footer Background color', 'nailhammer' ),
				'section' => 'footer_styles',
				'default' => '#181818',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'footer_widgets_bg_top' => array(
				'title'   => esc_html__( 'Footer Widgets Top Area Background color', 'nailhammer' ),
				'section' => 'footer_styles',
				'default' => '#1b1b1b',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'footer_widgets_bg_bottom' => array(
				'title'   => esc_html__( 'Footer Widgets Bottom Area Background color', 'nailhammer' ),
				'section' => 'footer_styles',
				'default' => '#222222',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'footer_widgets_bg_top_image' => array(
				'title'   => esc_html__( 'Footer Widgets Top Area Background Image', 'nailhammer' ),
				'section' => 'footer_styles',
				'default' => false,
				'field'   => 'image',
				'type'    => 'control',
			),
			'footer_widgets_bg_top_repeat' => array(
				'title'   => esc_html__( 'Footer Widgets Top Area Background Repeat,', 'nailhammer' ),
				'section' => 'footer_styles',
				'default' => 'no-repeat',
				'field'   => 'select',
				'choices' => array(
					'no-repeat' => esc_html__( 'No Repeat', 'nailhammer' ),
					'repeat'    => esc_html__( 'Tile', 'nailhammer' ),
					'repeat-x'  => esc_html__( 'Tile Horizontally', 'nailhammer' ),
					'repeat-y'  => esc_html__( 'Tile Vertically', 'nailhammer' ),
				),
				'type'    => 'control',
				'active_callback' => 'nailhammer_is_footer_widgets_bg_top_image',
			),
			'footer_widgets_bg_top_position_x' => array(
				'title'   => esc_html__( 'Footer Widgets Top Area Background Position', 'nailhammer' ),
				'section' => 'footer_styles',
				'default' => 'center',
				'field'   => 'select',
				'choices' => array(
					'left'   => esc_html__( 'Left', 'nailhammer' ),
					'center' => esc_html__( 'Center', 'nailhammer' ),
					'right'  => esc_html__( 'Right', 'nailhammer' ),
				),
				'type'    => 'control',
				'active_callback' => 'nailhammer_is_footer_widgets_bg_top_image',
			),
			'footer_widgets_bg_top_attachment' => array(
				'title'   => esc_html__( 'Footer Widgets Top Area Background Attachment', 'nailhammer' ),
				'section' => 'footer_styles',
				'default' => 'scroll',
				'field'   => 'select',
				'choices' => array(
					'scroll' => esc_html__( 'Scroll', 'nailhammer' ),
					'fixed'  => esc_html__( 'Fixed', 'nailhammer' ),
				),
				'type'    => 'control',
				'active_callback' => 'nailhammer_is_footer_widgets_bg_top_image',
			),
			'footer_widgets_bg_bottom_image' => array(
				'title'   => esc_html__( 'Footer Widgets Bottom Area Background Image', 'nailhammer' ),
				'section' => 'footer_styles',
				'field'   => 'image',
				'default' => false,
				'type'    => 'control',
			),
			'footer_widgets_bg_bottom_repeat' => array(
				'title'   => esc_html__( 'Footer Widgets Bottom Area Background Repeat', 'nailhammer' ),
				'section' => 'footer_styles',
				'default' => 'no-repeat',
				'field'   => 'select',
				'choices' => array(
					'no-repeat' => esc_html__( 'No Repeat', 'nailhammer' ),
					'repeat'    => esc_html__( 'Tile', 'nailhammer' ),
					'repeat-x'  => esc_html__( 'Tile Horizontally', 'nailhammer' ),
					'repeat-y'  => esc_html__( 'Tile Vertically', 'nailhammer' ),
				),
				'type'    => 'control',
				'active_callback' => 'nailhammer_is_footer_widgets_bg_bottom_image',
			),
			'footer_widgets_bg_bottom_position_x' => array(
				'title'   => esc_html__( 'Footer Widgets Bottom Area Background Position', 'nailhammer' ),
				'section' => 'footer_styles',
				'default' => 'center',
				'field'   => 'select',
				'choices' => array(
					'left'   => esc_html__( 'Left', 'nailhammer' ),
					'center' => esc_html__( 'Center', 'nailhammer' ),
					'right'  => esc_html__( 'Right', 'nailhammer' ),
				),
				'type'    => 'control',
				'active_callback' => 'nailhammer_is_footer_widgets_bg_bottom_image',
			),
			'footer_widgets_bg_bottom_attachment' => array(
				'title'   => esc_html__( 'Footer Widgets Bottom Area Background Attachment', 'nailhammer' ),
				'section' => 'footer_styles',
				'default' => 'scroll',
				'field'   => 'select',
				'choices' => array(
					'scroll' => esc_html__( 'Scroll', 'nailhammer' ),
					'fixed'  => esc_html__( 'Fixed', 'nailhammer' ),
				),
				'type'    => 'control',
				'active_callback' => 'nailhammer_is_footer_widgets_bg_top_image',
			),
			'footer_widget_area_visibility' => array(
				'title'   => esc_html__( 'Show Footer Widgets Area', 'nailhammer' ),
				'section' => 'footer_styles',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'footer_second_widget_area_visibility' => array(
				'title'   => esc_html__( 'Show Second Footer Widgets Area', 'nailhammer' ),
				'section' => 'footer_styles',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'footer_logo_visibility' => array(
				'title'   => esc_html__( 'Show Footer Logo', 'nailhammer' ),
				'section' => 'footer_styles',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'footer_menu_visibility' => array(
				'title'   => esc_html__( 'Show Footer Menu', 'nailhammer' ),
				'section' => 'footer_styles',
				'default' => false,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'footer_pay_systems' => array(
				'title'   => esc_html__( 'Show Pay Systems in Footer', 'nailhammer' ),
				'section' => 'footer_styles',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'pay_systems_url' => array(
				'title'   => esc_html__( 'Image pay system link', 'nailhammer' ),
				'section' => 'footer_styles',
				'field'   => 'text',
				'default' => 'https://www.paypal.com/',
				'type'    => 'control',
			),
			'pay_systems_src' => array(
				'title'   => esc_html__( 'Image pay system upload', 'nailhammer' ),
				'section' => 'footer_styles',
				'field'   => 'image',
				'default' => '%s/assets/images/pay_systems.png',
				'type'    => 'control',
			),

			/** `Footer contact block` section */
			'footer_contact_block' => array(
				'title'    => esc_html__( 'Footer Contact Block', 'nailhammer' ),
				'priority' => 10,
				'panel'    => 'footer_options',
				'type'     => 'section',
			),
			'footer_contact_block_visibility' => array(
				'title'   => esc_html__( 'Show Footer Contact Block', 'nailhammer' ),
				'section' => 'footer_contact_block',
				'default' => false,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'footer_contact_icon_1' => array(
				'title'       => esc_html__( 'Contact item 1', 'nailhammer' ),
				'description' => esc_html__( 'Choose icon', 'nailhammer' ),
				'section'     => 'footer_contact_block',
				'field'       => 'iconpicker',
				'default'     => false,
				'icon_data'   => array(
					'icon_set'    => 'nailhammerFontAwesome',
					'icon_css'    => NAILHAMMER_THEME_URI . '/assets/css/font-awesome.min.css',
					'icon_base'   => 'fa',
					'icon_prefix' => 'fa-',
					'icons'       => nailhammer_get_icons_set(),
				),
				'type'        => 'control',
			),
			'footer_contact_label_1' => array(
				'title'       => '',
				'description' => esc_html__( 'Label', 'nailhammer' ),
				'section'     => 'footer_contact_block',
				'default'     => esc_html__( 'Address:', 'nailhammer' ),
				'field'       => 'text',
				'type'        => 'control',
			),
			'footer_contact_text_1' => array(
				'title'       => '',
				'description' => esc_html__( 'Value (HTML formatting support)', 'nailhammer' ),
				'section'     => 'footer_contact_block',
				'default'     => nailhammer_get_default_footer_contact_information( 'address' ),
				'field'       => 'textarea',
				'type'        => 'control',
			),
			'footer_contact_icon_2' => array(
				'title'       => esc_html__( 'Contact item 2', 'nailhammer' ),
				'description' => esc_html__( 'Choose icon', 'nailhammer' ),
				'section'     => 'footer_contact_block',
				'field'       => 'iconpicker',
				'default'     => false,
				'icon_data'   => array(
					'icon_set'    => 'nailhammerFontAwesome',
					'icon_css'    => NAILHAMMER_THEME_URI . '/assets/css/font-awesome.min.css',
					'icon_base'   => 'fa',
					'icon_prefix' => 'fa-',
					'icons'       => nailhammer_get_icons_set(),
				),
				'type'        => 'control',
			),
			'footer_contact_label_2' => array(
				'title'       => '',
				'description' => esc_html__( 'Label', 'nailhammer' ),
				'section'     => 'footer_contact_block',
				'default'     => esc_html__( 'Phones:', 'nailhammer' ),
				'field'       => 'text',
				'type'        => 'control',
			),
			'footer_contact_text_2' => array(
				'title'       => '',
				'description' => esc_html__( 'Value (HTML formatting support)', 'nailhammer' ),
				'section'     => 'footer_contact_block',
				'default'     => nailhammer_get_default_footer_contact_information( 'phones' ),
				'field'       => 'textarea',
				'type'        => 'control',
			),
			'footer_contact_icon_3' => array(
				'title'       => esc_html__( 'Contact item 3', 'nailhammer' ),
				'description' => esc_html__( 'Choose icon', 'nailhammer' ),
				'section'     => 'footer_contact_block',
				'field'       => 'iconpicker',
				'default'     => false,
				'icon_data'   => array(
					'icon_set'    => 'nailhammerFontAwesome',
					'icon_css'    => NAILHAMMER_THEME_URI . '/assets/css/font-awesome.min.css',
					'icon_base'   => 'fa',
					'icon_prefix' => 'fa-',
					'icons'       => nailhammer_get_icons_set(),
				),
				'type'        => 'control',
			),
			'footer_contact_label_3' => array(
				'title'       => '',
				'description' => esc_html__( 'Label', 'nailhammer' ),
				'section'     => 'footer_contact_block',
				'default'     => esc_html__( 'E-mail:', 'nailhammer' ),
				'field'       => 'text',
				'type'        => 'control',
			),
			'footer_contact_text_3' => array(
				'title'       => '',
				'description' => esc_html__( 'Value (HTML formatting support)', 'nailhammer' ),
				'section'     => 'footer_contact_block',
				'default'     => nailhammer_get_default_footer_contact_information( 'email' ),
				'field'       => 'textarea',
				'type'        => 'control',
			),

			/** `Blog Settings` panel */
			'blog_settings' => array(
				'title'    => esc_html__( 'Blog Settings', 'nailhammer' ),
				'priority' => 115,
				'type'     => 'panel',
			),

			/** `Blog` section */
			'blog' => array(
				'title'           => esc_html__( 'Blog', 'nailhammer' ),
				'panel'           => 'blog_settings',
				'priority'        => 10,
				'type'            => 'section',
			),
			'blog_layout_type' => array(
				'title'   => esc_html__( 'Layout', 'nailhammer' ),
				'section' => 'blog',
				'default' => 'default',
				'field'   => 'select',
				'choices' => array(
					'default'          => esc_html__( 'Listing', 'nailhammer' ),
					'grid-3-cols'      => esc_html__( 'Grid (3 Columns)', 'nailhammer' ),
					'grid-4-cols'      => esc_html__( 'Grid (4 Columns)', 'nailhammer' ),
					'masonry-3-cols'   => esc_html__( 'Masonry (3 Columns)', 'nailhammer' ),
					'masonry-4-cols'   => esc_html__( 'Masonry (4 Columns)', 'nailhammer' ),
					'vertical-justify' => esc_html__( 'Vertical Justify', 'nailhammer' ),
				),
				'type' => 'control',
			),
			'blog_sticky_type' => array(
				'title'   => esc_html__( 'Sticky label type', 'nailhammer' ),
				'section' => 'blog',
				'default' => 'icon',
				'field'   => 'select',
				'choices' => array(
					'label' => esc_html__( 'Text Label', 'nailhammer' ),
					'icon'  => esc_html__( 'Font Icon', 'nailhammer' ),
					'both'  => esc_html__( 'Text with Icon', 'nailhammer' ),
				),
				'type' => 'control',
			),
			'blog_sticky_icon' => array(
				'title'           => esc_html__( 'Icon for sticky post', 'nailhammer' ),
				'section'         => 'blog',
				'field'           => 'iconpicker',
				'default'         => 'fa-star-o',
				'icon_data'       => array(
					'icon_set'    => 'nailhammerFontAwesome',
					'icon_css'    => NAILHAMMER_THEME_URI . '/assets/css/font-awesome.min.css',
					'icon_base'   => 'fa',
					'icon_prefix' => 'fa-',
					'icons'       => nailhammer_get_icons_set(),
				),
				'type'            => 'control',
				'active_callback' => 'nailhammer_is_sticky_icon',
			),
			'blog_sticky_label' => array(
				'title'           => esc_html__( 'Featured Post Label', 'nailhammer' ),
				'description'     => esc_html__( 'Label for sticky post', 'nailhammer' ),
				'section'         => 'blog',
				'default'         => esc_html__( 'Featured', 'nailhammer' ),
				'field'           => 'text',
				'active_callback' => 'nailhammer_is_sticky_text',
				'type'            => 'control',
			),
			'blog_posts_content' => array(
				'title'   => esc_html__( 'Post content', 'nailhammer' ),
				'section' => 'blog',
				'default' => 'excerpt',
				'field'   => 'select',
				'choices' => array(
					'excerpt' => esc_html__( 'Only excerpt', 'nailhammer' ),
					'full'    => esc_html__( 'Full content', 'nailhammer' ),
					'none'    => esc_html__( 'Hide', 'nailhammer' ),
				),
				'type' => 'control',
			),
			'blog_featured_image' => array(
				'title'           => esc_html__( 'Featured image', 'nailhammer' ),
				'section'         => 'blog',
				'default'         => 'fullwidth',
				'field'           => 'select',
				'choices'         => array(
					'small'     => esc_html__( 'Small', 'nailhammer' ),
					'fullwidth' => esc_html__( 'Fullwidth', 'nailhammer' ),
				),
				'type'            => 'control',
				'active_callback' => 'nailhammer_is_blog_featured_image',
			),
			'blog_read_more_text' => array(
				'title'       => esc_html__( 'Read More button text', 'nailhammer' ),
				'description' => esc_html__( 'Leave empty to hide button', 'nailhammer' ),
				'section'     => 'blog',
				'default'     => esc_html__( 'Read more', 'nailhammer' ),
				'field'       => 'text',
				'type'        => 'control',
			),
			'blog_post_author' => array(
				'title'   => esc_html__( 'Show post author', 'nailhammer' ),
				'section' => 'blog',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'blog_post_publish_date' => array(
				'title'   => esc_html__( 'Show publish date', 'nailhammer' ),
				'section' => 'blog',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'blog_post_categories' => array(
				'title'   => esc_html__( 'Show categories', 'nailhammer' ),
				'section' => 'blog',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'blog_post_tags' => array(
				'title'   => esc_html__( 'Show tags', 'nailhammer' ),
				'section' => 'blog',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'blog_post_comments' => array(
				'title'   => esc_html__( 'Show comments', 'nailhammer' ),
				'section' => 'blog',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),

			/** `Post` section */
			'blog_post' => array(
				'title'           => esc_html__( 'Post', 'nailhammer' ),
				'panel'           => 'blog_settings',
				'priority'        => 20,
				'type'            => 'section',
				'active_callback' => 'callback_single',
			),
			'single_post_type' => array(
				'title'   => esc_html__( 'Post style', 'nailhammer' ),
				'section' => 'blog_post',
				'default' => 'default',
				'field'   => 'select',
				'choices' => array(
					'default' => esc_html__( 'Default', 'nailhammer' ),
					'modern'  => esc_html__( 'Modern', 'nailhammer' ),
				),
				'type' => 'control',
			),
			'single_post_author' => array(
				'title'   => esc_html__( 'Show post author', 'nailhammer' ),
				'section' => 'blog_post',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'single_post_publish_date' => array(
				'title'   => esc_html__( 'Show publish date', 'nailhammer' ),
				'section' => 'blog_post',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'single_post_categories' => array(
				'title'   => esc_html__( 'Show categories', 'nailhammer' ),
				'section' => 'blog_post',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'single_post_tags' => array(
				'title'   => esc_html__( 'Show tags', 'nailhammer' ),
				'section' => 'blog_post',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'single_post_comments' => array(
				'title'   => esc_html__( 'Show comments', 'nailhammer' ),
				'section' => 'blog_post',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'single_author_block' => array(
				'title'   => esc_html__( 'Enable the author block after each post', 'nailhammer' ),
				'section' => 'blog_post',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'single_post_navigation' => array(
				'title'   => esc_html__( 'Enable post navigation', 'nailhammer' ),
				'section' => 'blog_post',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),

			/** `Related Posts` section */
			'related_posts' => array(
				'title'           => esc_html__( 'Related posts block', 'nailhammer' ),
				'panel'           => 'blog_settings',
				'priority'        => 30,
				'type'            => 'section',
				'active_callback' => 'callback_single',
			),
			'related_posts_visible' => array(
				'title'   => esc_html__( 'Show related posts block', 'nailhammer' ),
				'section' => 'related_posts',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'related_posts_block_title' => array(
				'title'   => esc_html__( 'Related posts block title', 'nailhammer' ),
				'section' => 'related_posts',
				'default' => esc_html__( ' ', 'nailhammer' ),
				'field'   => 'text',
				'type'    => 'control',
			),
			'related_posts_count' => array(
				'title'   => esc_html__( 'Number of post', 'nailhammer' ),
				'section' => 'related_posts',
				'default' => '2',
				'field'   => 'text',
				'type'    => 'control',
			),
			'related_posts_grid' => array(
				'title'   => esc_html__( 'Layout', 'nailhammer' ),
				'section' => 'related_posts',
				'default' => '2',
				'field'   => 'select',
				'choices' => array(
					'2' => esc_html__( '2 columns', 'nailhammer' ),
					'3' => esc_html__( '3 columns', 'nailhammer' ),
					'4' => esc_html__( '4 columns', 'nailhammer' ),
				),
				'type'    => 'control',
			),
			'related_posts_title' => array(
				'title'   => esc_html__( 'Show post title', 'nailhammer' ),
				'section' => 'related_posts',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'related_posts_title_length' => array(
				'title'   => esc_html__( 'Number of words in the title', 'nailhammer' ),
				'section' => 'related_posts',
				'default' => '10',
				'field'   => 'text',
				'type'    => 'control',
			),
			'related_posts_image' => array(
				'title'   => esc_html__( 'Show post image', 'nailhammer' ),
				'section' => 'related_posts',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'related_posts_content' => array(
				'title'   => esc_html__( 'Display content', 'nailhammer' ),
				'section' => 'related_posts',
				'default' => 'hide',
				'field'   => 'select',
				'choices' => array(
					'hide'         => esc_html__( 'Hide', 'nailhammer' ),
					'post_excerpt' => esc_html__( 'Excerpt', 'nailhammer' ),
					'post_content' => esc_html__( 'Content', 'nailhammer' ),
				),
				'type'    => 'control',
			),
			'related_posts_content_length' => array(
				'title'   => esc_html__( 'Number of words in the content', 'nailhammer' ),
				'section' => 'related_posts',
				'default' => '25',
				'field'   => 'text',
				'type'    => 'control',
			),
			'related_posts_categories' => array(
				'title'   => esc_html__( 'Show post categories', 'nailhammer' ),
				'section' => 'related_posts',
				'default' => false,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'related_posts_tags' => array(
				'title'   => esc_html__( 'Show post tags', 'nailhammer' ),
				'section' => 'related_posts',
				'default' => false,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'related_posts_author' => array(
				'title'   => esc_html__( 'Show post author', 'nailhammer' ),
				'section' => 'related_posts',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'related_posts_publish_date' => array(
				'title'   => esc_html__( 'Show post publish date', 'nailhammer' ),
				'section' => 'related_posts',
				'default' => true,
				'field'   => 'checkbox',
				'type'    => 'control',
			),
			'related_posts_comment_count' => array(
				'title'   => esc_html__( 'Show post comment count', 'nailhammer' ),
				'section' => 'related_posts',
				'default' => false,
				'field'   => 'checkbox',
				'type'    => 'control',
			),

			/** `Woocommerce Settings` panel */
			'woocommerce_settings' => array(
				'title'           => esc_html__( 'Woocommerce options', 'nailhammer' ),
				'priority'        => 120,
				'type'            => 'panel',
				'active_callback' => 'nailhammer_is_woocommerce_activated',
			),
			/** `Badge` section */
			'woo_badge_options' => array(
				'title'    => esc_html__( 'Woocommerce badge', 'nailhammer' ),
				'panel'    => 'woocommerce_settings',
				'priority' => 10,
				'type'     => 'section',
			),
			'onsale_badge_color' => array(
				'title'   => esc_html__( 'Onsale badge color', 'nailhammer' ),
				'section' => 'woo_badge_options',
				'default' => '#ffffff',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'onsale_badge_bg' => array(
				'title'   => esc_html__( 'Onsale badge bg', 'nailhammer' ),
				'section' => 'woo_badge_options',
				'default' => '#ed4c21',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'featured_badge_color' => array(
				'title'   => esc_html__( 'Featured badge color', 'nailhammer' ),
				'section' => 'woo_badge_options',
				'default' => '#ffffff',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'featured_badge_bg' => array(
				'title'   => esc_html__( 'Featured badge bg', 'nailhammer' ),
				'section' => 'woo_badge_options',
				'default' => '#008cd1',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'new_badge_color' => array(
				'title'   => esc_html__( 'New badge color', 'nailhammer' ),
				'section' => 'woo_badge_options',
				'default' => '#ffffff',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'new_badge_bg' => array(
				'title'   => esc_html__( 'New badge bg', 'nailhammer' ),
				'section' => 'woo_badge_options',
				'default' => '#2380ae',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'in_stock_badge_color' => array(
				'title'   => esc_html__( 'In stock badge color', 'nailhammer' ),
				'section' => 'woo_badge_options',
				'default' => '#ffffff',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'out_stock_badge_color' => array(
				'title'   => esc_html__( 'Out of stock badge color', 'nailhammer' ),
				'section' => 'woo_badge_options',
				'default' => '#ffffff',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'vendors_budge_color' => array(
				'title'   => esc_html__( 'VC vendors badge color', 'nailhammer' ),
				'section' => 'woo_badge_options',
				'default' => '#ffffff',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'vendors_budge_bg' => array(
				'title'   => esc_html__( 'VC vendors badge background', 'nailhammer' ),
				'section' => 'woo_badge_options',
				'default' => '#1b1b1b',
				'field'   => 'hex_color',
				'type'    => 'control',
			),
			'woo_page_options' => array(
				'title'           => esc_html__( 'Woocommerce page options', 'nailhammer' ),
				'panel'           => 'woocommerce_settings',
				'priority'        => 12,
				'type'            => 'section',
			),
			'woo_column_numbers_desktop' => array(
				'title'   => esc_html__( 'WooCommerce loop columns desktop', 'nailhammer' ),
				'section' => 'woo_page_options',
				'default' => '3',
				'field'   => 'select',
				'choices' => array(
					'6'   => esc_html__( '6 columns (4 columns with sidebar)', 'nailhammer' ),
					'4'   => esc_html__( '4 columns', 'nailhammer' ),
					'3'   => esc_html__( '3 columns', 'nailhammer' ),
					'2'   => esc_html__( '2 columns', 'nailhammer' ),
				),
				'type' => 'control',
			),
			'woo_column_numbers_laptop' => array(
				'title'   => esc_html__( 'WooCommerce loop columns laptop', 'nailhammer' ),
				'section' => 'woo_page_options',
				'default' => '3',
				'field'   => 'select',
				'choices' => array(
					'4'   => esc_html__( '4 columns', 'nailhammer' ),
					'3'   => esc_html__( '3 columns', 'nailhammer' ),
					'2'   => esc_html__( '2 columns', 'nailhammer' ),
				),
				'type' => 'control',
			),
			'woo_column_numbers_tablet' => array(
				'title'   => esc_html__( 'WooCommerce loop columns mobile', 'nailhammer' ),
				'section' => 'woo_page_options',
				'default' => '3',
				'field'   => 'select',
				'choices' => array(
					'4'   => esc_html__( '4 columns', 'nailhammer' ),
					'3'   => esc_html__( '3 columns', 'nailhammer' ),
					'2'   => esc_html__( '2 columns', 'nailhammer' ),
				),
				'type' => 'control',
			),
			'enable_carousel_thumbnails' => array(
				'title'    => esc_html__( 'Enable single product carousel on the thumbnails', 'nailhammer' ),
				'section'  => 'woo_page_options',
				'priority' => 120,
				'default'  => true,
				'field'    => 'checkbox',
				'type'     => 'control',
			),
			/** `404` panel */
			'page_404_options' => array(
				'title'    => esc_html__( '404 Page', 'nailhammer' ),
				'priority' => 130,
				'type'     => 'section',
			),
			'page_404_bg_color' => array(
				'title'   => esc_html__( 'Background Color', 'nailhammer' ),
				'section' => 'page_404_options',
				'field'   => 'hex_color',
				'default' => '#ffffff',
				'type'    => 'control',
			),
			'page_404_bg_image' => array(
				'title'   => esc_html__( 'Background Image', 'nailhammer' ),
				'section' => 'page_404_options',
				'field'   => 'image',
				'default' => '%s/assets/images/bg_404.jpg',
				'type'    => 'control',
			),
			'page_404_bg_repeat' => array(
				'title'   => esc_html__( 'Background Repeat', 'nailhammer' ),
				'section' => 'page_404_options',
				'default' => 'no-repeat',
				'field'   => 'select',
				'choices' => array(
					'no-repeat'  => esc_html__( 'No Repeat', 'nailhammer' ),
					'repeat'     => esc_html__( 'Tile', 'nailhammer' ),
					'repeat-x'   => esc_html__( 'Tile Horizontally', 'nailhammer' ),
					'repeat-y'   => esc_html__( 'Tile Vertically', 'nailhammer' ),
				),
				'type' => 'control',
			),
			'page_404_bg_position_x' => array(
				'title'   => esc_html__( 'Background Position', 'nailhammer' ),
				'section' => 'page_404_options',
				'default' => 'center',
				'field'   => 'select',
				'choices' => array(
					'left'   => esc_html__( 'Left', 'nailhammer' ),
					'center' => esc_html__( 'Center', 'nailhammer' ),
					'right'  => esc_html__( 'Right', 'nailhammer' ),
				),
				'type' => 'control',
			),
			'page_404_bg_attachment' => array(
				'title'   => esc_html__( 'Background Attachment', 'nailhammer' ),
				'section' => 'page_404_options',
				'default' => 'scroll',
				'field'   => 'select',
				'choices' => array(
					'scroll' => esc_html__( 'Scroll', 'nailhammer' ),
					'fixed'  => esc_html__( 'Fixed', 'nailhammer' ),
				),
				'type' => 'control',
			)
		),
	) );
}

/**
 * Return true if setting is value. Otherwise - return false.
 *
 * @param  object $control Parent control.
 * @param  string $setting Setting name to check.
 * @param  string $value   Setting value to compare.
 * @return bool
 */
function nailhammer_is_setting( $control, $setting, $value ) {

	if ( $value == $control->manager->get_setting( $setting )->value() ) {
		return true;
	}

	return false;
}

/**
 * Return true if value of passed setting is not equal with passed value.
 *
 * @param  object $control Parent control.
 * @param  string $setting Setting name to check.
 * @param  string $value   Setting value to compare.
 * @return bool
 */
function nailhammer_is_not_setting( $control, $setting, $value ) {

	if ( $value !== $control->manager->get_setting( $setting )->value() ) {
		return true;
	}

	return false;
}

/**
 * Return true if logo in header has image type. Otherwise - return false.
 *
 * @param  object $control Parent control.
 * @return bool
 */
function nailhammer_is_header_logo_image( $control ) {
	return nailhammer_is_setting( $control, 'header_logo_type', 'image' );
}

/**
 * Return true if logo in header has text type. Otherwise - return false.
 *
 * @param  object $control Parent control.
 * @return bool
 */
function nailhammer_is_header_logo_text( $control ) {
	return nailhammer_is_setting( $control, 'header_logo_type', 'text' );
}

/**
 * Return blog-featured-image true if blog layout type is default. Otherwise - return false.
 *
 * @param  object $control Parent control.
 * @return bool
 */
function nailhammer_is_blog_featured_image( $control ) {
	return nailhammer_is_setting( $control, 'blog_layout_type', 'default' );
}

/**
 * Return true if sticky label type set to text or text with icon.
 *
 * @param  object $control Parent control.
 * @return bool
 */
function nailhammer_is_sticky_text( $control ) {
	return nailhammer_is_not_setting( $control, 'blog_sticky_type', 'icon' );
}

/**
 * Return true if sticky label type set to icon or text with icon.
 *
 * @param  object $control Parent control.
 * @return bool
 */
function nailhammer_is_sticky_icon( $control ) {
	return nailhammer_is_not_setting( $control, 'blog_sticky_type', 'label' );
}

/**
 * Return true if More button (in the main menu) has image type. Otherwise - return false.
 *
 * @param  object $control Parent control.
 * @return bool
 */
function nailhammer_is_more_button_type_image( $control ) {

	if ( $control->manager->get_setting( 'more_button_type' )->value() == 'image' ) {
		return true;
	}

	return false;
}

/**
 * Return true if footer widgets bg top image (in the Footer Styles)
 *
 * @param  object $control Parent control.
 * @return bool
 */
function nailhammer_is_footer_widgets_bg_top_image( $control ) {

	if ( !$control->manager->get_setting( 'footer_widgets_bg_top_image' )->value() == '' ) {
		return true;
	}

	return false;
}

/**
 * Return true if footer widgets bg bottom image (in the Footer Styles)
 *
 * @param  object $control Parent control.
 * @return bool
 */
function nailhammer_is_footer_widgets_bg_bottom_image( $control ) {

	if ( !$control->manager->get_setting( 'footer_widgets_bg_bottom_image' )->value() == '' ) {
		return true;
	}

	return false;
}

/**
 * Return true if More button (in the main menu) has text type. Otherwise - return false.
 *
 * @param  object $control Parent control.
 * @return bool
 */
function nailhammer_is_more_button_type_text( $control ) {

	if ( $control->manager->get_setting( 'more_button_type' )->value() == 'text' ) {
		return true;
	}

	return false;
}

/**
 * Return true if More button (in the main menu) has icon type. Otherwise - return false.
 *
 * @param  object $control Parent control.
 * @return bool
 */
function nailhammer_is_more_button_type_icon( $control ) {

	if ( $control->manager->get_setting( 'more_button_type' )->value() == 'icon' ) {
		return true;
	}

	return false;
}

/**
 * Get default header layouts.
 *
 * @since  1.0.0
 * @return array
 */
function nailhammer_get_header_layout_options() {
	return apply_filters( 'nailhammer_header_layout_options', array(
		'default'    => esc_html__( 'Style 1', 'nailhammer' ),
		'style-2'   => esc_html__( 'Style 2', 'nailhammer' ),
		'style-3'    => esc_html__( 'Style 3', 'nailhammer' ),
	) );
}

/**
 * Get default header layouts options for Post Meta boxes
 *
 * @return array
 */
function nailhammer_get_header_layout_pm_options() {
	$inherit_option = array(
		'inherit' => esc_html__( 'Inherit', 'nailhammer' ),
	);

	$options = nailhammer_get_header_layout_options();

	return array_merge( $inherit_option, $options );
}

// Move native `site_icon` control (based on WordPress core) in custom section.
add_action( 'customize_register', 'nailhammer_customizer_change_core_controls', 20 );
/**
 * Move native `site_icon` control (based on WordPress core) into custom section.
 *
 * @since 1.0.0
 * @param  object $wp_customize Object wp_customize.
 * @return void
 */
function nailhammer_customizer_change_core_controls( $wp_customize ) {
	$wp_customize->get_control( 'site_icon' )->section      = 'nailhammer_logo_favicon';
	$wp_customize->get_control( 'background_color' )->label = esc_html__( 'Body Background Color', 'nailhammer' );
}

// Typography utility function
/**
 * Get font styles
 *
 * @since 1.0.0
 * @return array
 */
function nailhammer_get_font_styles() {
	return apply_filters( 'nailhammer_get_font_styles', array(
		'normal'  => esc_html__( 'Normal', 'nailhammer' ),
		'italic'  => esc_html__( 'Italic', 'nailhammer' ),
		'oblique' => esc_html__( 'Oblique', 'nailhammer' ),
		'inherit' => esc_html__( 'Inherit', 'nailhammer' ),
	) );
}

/**
 * Get character sets
 *
 * @since 1.0.0
 * @return array
 */
function nailhammer_get_character_sets() {
	return apply_filters( 'nailhammer_get_character_sets', array(
		'latin'        => esc_html__( 'Latin', 'nailhammer' ),
		'greek'        => esc_html__( 'Greek', 'nailhammer' ),
		'greek-ext'    => esc_html__( 'Greek Extended', 'nailhammer' ),
		'vietnamese'   => esc_html__( 'Vietnamese', 'nailhammer' ),
		'cyrillic-ext' => esc_html__( 'Cyrillic Extended', 'nailhammer' ),
		'latin-ext'    => esc_html__( 'Latin Extended', 'nailhammer' ),
		'cyrillic'     => esc_html__( 'Cyrillic', 'nailhammer' ),
	) );
}

/**
 * Get text aligns
 *
 * @since 1.0.0
 * @return array
 */
function nailhammer_get_text_aligns() {
	return apply_filters( 'nailhammer_get_text_aligns', array(
		'inherit' => esc_html__( 'Inherit', 'nailhammer' ),
		'center'  => esc_html__( 'Center', 'nailhammer' ),
		'justify' => esc_html__( 'Justify', 'nailhammer' ),
		'left'    => esc_html__( 'Left', 'nailhammer' ),
		'right'   => esc_html__( 'Right', 'nailhammer' ),
	) );
}

/**
 * Get font weights
 *
 * @since 1.0.0
 * @return array
 */
function nailhammer_get_font_weight() {
	return apply_filters( 'nailhammer_get_font_weight', array(
		'100' => '100',
		'200' => '200',
		'300' => '300',
		'400' => '400',
		'500' => '500',
		'600' => '600',
		'700' => '700',
		'800' => '800',
		'900' => '900',
	) );
}

/**
 * Return array of arguments for dynamic CSS module
 *
 * @return array
 */
function nailhammer_get_dynamic_css_options() {
	return apply_filters( 'nailhammer_get_dynamic_css_options', array(
		'prefix'    => 'nailhammer',
		'type'      => 'theme_mod',
		'single'    => true,
		'css_files' => array(
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic-woo.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/site/elements.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/site/header.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/site/forms.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/site/social.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/site/menus.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/site/post.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/site/navigation.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/site/footer.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/site/misc.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/site/buttons.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/widgets/widget-default.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/widgets/taxonomy-tiles.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/widgets/image-grid.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/widgets/carousel.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/widgets/smart-slider.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/widgets/subscribe.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/widgets/custom-posts.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/widgets/playlist-slider.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/widgets/featured-posts-block.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/widgets/news-smart-box.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/widgets/contact-information.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/plugins/cherry-popups.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/plugins/timeline.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/plugins/wc-vendor.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/plugins/cherry-team-members.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/plugins/cherry-testimonials.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/plugins/motopress-slider.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/plugins/wc-vendors.css',
			NAILHAMMER_THEME_DIR . '/assets/css/dynamic/builder/icon-box.css',

		),
		'options' => array(
			'main_box_color',

			'header_logo_font_style',
			'header_logo_font_weight',
			'header_logo_font_size',
			'header_logo_font_family',

			'body_font_style',
			'body_font_weight',
			'body_font_size',
			'body_line_height',
			'body_font_family',
			'body_letter_spacing',
			'body_text_align',

			'h1_font_style',
			'h1_font_weight',
			'h1_font_size',
			'h1_line_height',
			'h1_font_family',
			'h1_letter_spacing',
			'h1_text_align',

			'h2_font_style',
			'h2_font_weight',
			'h2_font_size',
			'h2_line_height',
			'h2_font_family',
			'h2_letter_spacing',
			'h2_text_align',

			'h3_font_style',
			'h3_font_weight',
			'h3_font_size',
			'h3_line_height',
			'h3_font_family',
			'h3_letter_spacing',
			'h3_text_align',

			'h4_font_style',
			'h4_font_weight',
			'h4_font_size',
			'h4_line_height',
			'h4_font_family',
			'h4_letter_spacing',
			'h4_text_align',

			'h5_font_style',
			'h5_font_weight',
			'h5_font_size',
			'h5_line_height',
			'h5_font_family',
			'h5_letter_spacing',
			'h5_text_align',

			'h6_font_style',
			'h6_font_weight',
			'h6_font_size',
			'h6_line_height',
			'h6_font_family',
			'h6_letter_spacing',
			'h6_text_align',

			'breadcrumbs_font_style',
			'breadcrumbs_font_weight',
			'breadcrumbs_font_size',
			'breadcrumbs_line_height',
			'breadcrumbs_font_family',
			'breadcrumbs_letter_spacing',
			'breadcrumbs_text_align',

			'meta_font_style',
			'meta_font_weight',
			'meta_font_size',
			'meta_line_height',
			'meta_font_family',
			'meta_letter_spacing',
			'meta_text_align',

			'regular_accent_color_1',
			'regular_accent_color_2',
			'regular_accent_color_3',
			'regular_accent_color_4',
			'regular_accent_color_5',
			'regular_text_color',
			'regular_link_color',
			'regular_link_hover_color',
			'regular_h1_color',
			'regular_h2_color',
			'regular_h3_color',
			'regular_h4_color',
			'regular_h5_color',
			'regular_h6_color',

			'invert_accent_color_1',
			'invert_accent_color_2',
			'invert_accent_color_3',
			'invert_text_color',
			'invert_link_color',
			'invert_link_hover_color',
			'invert_h1_color',
			'invert_h2_color',
			'invert_h3_color',
			'invert_h4_color',
			'invert_h5_color',
			'invert_h6_color',

			'header_bg_color',
			'header_bg_image',
			'header_bg_repeat',
			'header_bg_position_x',
			'header_bg_attachment',

			'page_404_bg_color',
			'page_404_bg_repeat',
			'page_404_bg_position_x',
			'page_404_bg_attachment',

			'top_panel_bg',

			'container_width',

			'footer_widgets_bg_top',
			'footer_widgets_bg_top_image',
			'footer_widgets_bg_top_repeat',
			'footer_widgets_bg_top_position_x',
			'footer_widgets_bg_top_attachment',

			'footer_widgets_bg_bottom',
			'footer_widgets_bg_bottom_image',
			'footer_widgets_bg_bottom_repeat',
			'footer_widgets_bg_bottom_position_x',
			'footer_widgets_bg_bottom_attachment',
			'footer_bg',

			'onsale_badge_color',
			'onsale_badge_bg',
			'featured_badge_color',
			'featured_badge_bg',
			'new_badge_color',
			'new_badge_bg',
			'in_stock_badge_color',
			'out_stock_badge_color',
			'vendors_budge_color',
			'vendors_budge_bg',
		),
	) );
}

/**
 * Return array of arguments for Google Font loader module.
 *
 * @since  1.0.0
 * @return array
 */
function nailhammer_get_fonts_options() {
	return apply_filters( 'nailhammer_get_fonts_options', array(
		'prefix'  => 'nailhammer',
		'type'    => 'theme_mod',
		'single'  => true,
		'options' => array(
			'body' => array(
				'family'  => 'body_font_family',
				'style'   => 'body_font_style',
				'weight'  => 'body_font_weight',
				'charset' => 'body_character_set',
			),
			'h1' => array(
				'family'  => 'h1_font_family',
				'style'   => 'h1_font_style',
				'weight'  => 'h1_font_weight',
				'charset' => 'h1_character_set',
			),
			'h2' => array(
				'family'  => 'h2_font_family',
				'style'   => 'h2_font_style',
				'weight'  => 'h2_font_weight',
				'charset' => 'h2_character_set',
			),
			'h3' => array(
				'family'  => 'h3_font_family',
				'style'   => 'h3_font_style',
				'weight'  => 'h3_font_weight',
				'charset' => 'h3_character_set',
			),
			'h4' => array(
				'family'  => 'h4_font_family',
				'style'   => 'h4_font_style',
				'weight'  => 'h4_font_weight',
				'charset' => 'h4_character_set',
			),
			'h5' => array(
				'family'  => 'h5_font_family',
				'style'   => 'h5_font_style',
				'weight'  => 'h5_font_weight',
				'charset' => 'h5_character_set',
			),
			'h6' => array(
				'family'  => 'h6_font_family',
				'style'   => 'h6_font_style',
				'weight'  => 'h6_font_weight',
				'charset' => 'h6_character_set',
			),
			'meta' => array(
				'family'  => 'meta_font_family',
				'style'   => 'meta_font_style',
				'weight'  => 'meta_font_weight',
				'charset' => 'meta_character_set',
			),
			'header_logo' => array(
				'family'  => 'header_logo_font_family',
				'style'   => 'header_logo_font_style',
				'weight'  => 'header_logo_font_weight',
				'charset' => 'header_logo_character_set',
			),
			'breadcrumbs' => array(
				'family'  => 'breadcrumbs_font_family',
				'style'   => 'breadcrumbs_font_style',
				'weight'  => 'breadcrumbs_font_weight',
				'charset' => 'breadcrumbs_character_set',
			),
		),
	) );
}

/**
 * Get default footer copyright.
 *
 * @since  1.0.0
 * @return string
 */
function nailhammer_get_default_footer_copyright() {
	return esc_html__( 'is proudly powered by WordPress Entries (RSS) and Comments (RSS) %%privacy-policy%%', 'nailhammer' );
}

/**
 * Get default contact information.
 *
 * @since  1.0.0
 * @return string
 */
function nailhammer_get_default_contact_information( $value ) {
	$contact_information = array(
		'address' => esc_html__( '7 Days a week from 9:00 am to 7:00 pm', 'nailhammer' ),
	);

	return $contact_information[ $value ];
}

function nailhammer_get_default_footer_contact_information( $value ) {
	$contact_information = array(
		'address' => esc_html__( '7 Days a week from 9:00 am to 7:00 pm', 'nailhammer' ),
		'phones'  => sprintf( '<a href="tel:%1$s">%1$s</a>; <a href="tel:%2$s">%2$s</a>', esc_html__( '+3(800) 2345-6789', 'nailhammer' ), esc_html__( '+3(800) 2345-6790', 'nailhammer' ) ),
		'time'    => esc_html__( 'Mn-Fr: 10 am-8 pm', 'nailhammer' ),
		'email'   => sprintf( '<a href="mailto:%1$s">%1$s</a>', esc_html__( 'info@demolink.org', 'nailhammer' ) ),
	);

	return $contact_information[ $value ];
}

/**
 * Get FontAwesome icons set
 *
 * @return array
 */
function nailhammer_get_icons_set() {

	ob_start();

	include NAILHAMMER_THEME_DIR . '/assets/js/icons.json';
	$json = ob_get_clean();

	$result = array();
	$icons = json_decode( $json, true );

	foreach ( $icons['icons'] as $icon ) {
		$result[] = $icon['id'];
	}

	return $result;
}



